import crafttweaker.api.item.IItemStack;

val barrels = [
    <item:charm:oak_barrel>,
    <item:charm:spruce_barrel>,
    <item:charm:birch_barrel>,
    <item:charm:jungle_barrel>,
    <item:charm:acacia_barrel>,
    <item:charm:dark_oak_barrel>,
] as IItemStack[];

val chests = [
    <item:quark:oak_chest>,
    <item:quark:spruce_chest>,
    <item:quark:birch_chest>,
    <item:quark:jungle_chest>,
    <item:quark:acacia_chest>,
    <item:quark:dark_oak_chest>
] as IItemStack[];

val trapped_chests = [
    <item:quark:oak_trapped_chest>,
    <item:quark:spruce_trapped_chest>,
    <item:quark:birch_trapped_chest>,
    <item:quark:jungle_trapped_chest>,
    <item:quark:acacia_trapped_chest>,
    <item:quark:dark_oak_trapped_chest>
] as IItemStack[];

// Conversions from wooden modded barrels and chests to vanilla variant
for barrel in barrels {
    // charm_oak_barrel_to_vanilla
    craftingTable.addShapeless(barrel.registryName.namespace + "_" + barrel.registryName.path + "_to_vanilla",
        <item:minecraft:barrel>,
        [barrel]);
}

for chest in chests {
    // quark_oak_chest_to_vanilla
    craftingTable.addShapeless(chest.registryName.namespace + "_" + chest.registryName.path + "_to_vanilla",
        <item:minecraft:chest>,
        [chest]);
}

for trapped_chest in trapped_chests {
    // quark_oak_trapped_chest_to_vanilla
    craftingTable.addShapeless(trapped_chest.registryName.namespace + "_" + trapped_chest.registryName.path + "_to_vanilla",
        <item:minecraft:trapped_chest>,
        [trapped_chest]);
}
// readd vanilla recipe
craftingTable.addShapeless("vanilla_trapped_chest", <item:minecraft:trapped_chest>, [<item:minecraft:chest>, <item:minecraft:tripwire_hook>]);
