/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.tile;

import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.tile.TileInventory;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class TileInventoryFiltered
extends TileInventory {
    private InputFilter inputFilter = null;
    private ExtractFilter extractFilter = null;

    public TileInventoryFiltered(@Nonnull TileEntitySynchronized tile, @Nonnull Supplier<Integer> slotCountProvider, Direction ... applicableSides) {
        super(tile, slotCountProvider, applicableSides);
    }

    public TileInventoryFiltered(@Nonnull TileEntitySynchronized tile, @Nonnull Supplier<Integer> slotCountProvider, @Nullable Consumer<Integer> changeListener, Direction ... applicableSides) {
        super(tile, slotCountProvider, changeListener, applicableSides);
    }

    protected TileInventoryFiltered(@Nonnull TileEntitySynchronized tile, @Nonnull Supplier<Integer> slotCountProvider, @Nullable Consumer<Integer> changeListener, @Nonnull Collection<Direction> applicableSides, @Nonnull BiFunction<Integer, ItemStack, Integer> stackSizeLimiter) {
        super(tile, slotCountProvider, changeListener, applicableSides, stackSizeLimiter);
    }

    public TileInventoryFiltered canInsert(InputFilter filter) {
        this.inputFilter = filter;
        return this;
    }

    public TileInventoryFiltered canExtract(ExtractFilter filter) {
        this.extractFilter = filter;
        return this;
    }

    @Override
    protected TileInventoryFiltered makeNewInstance() {
        TileInventoryFiltered inv = new TileInventoryFiltered(this.tile, (Supplier<Integer>)this.slotCountProvider, (Consumer<Integer>)this.changeListener, MiscUtils.copySet(this.applicableSides), this.stackSizeLimiter);
        inv.canInsert(this.inputFilter);
        inv.canExtract(this.extractFilter);
        return inv;
    }

    @Override
    @Nonnull
    public TileInventoryFiltered deserialize(CompoundNBT tag) {
        return (TileInventoryFiltered)super.deserialize(tag);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.canInsertItem(slot, stack, this.getStackInSlot(slot))) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtractItem(slot, amount, this.getStackInSlot(slot))) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canInsertItem(int slot, ItemStack toAdd) {
        return this.canInsertItem(slot, toAdd, this.getStackInSlot(slot));
    }

    private boolean canInsertItem(int slot, ItemStack toAdd, @Nonnull ItemStack existing) {
        return this.inputFilter == null || this.inputFilter.canInsert(slot, toAdd, existing);
    }

    public boolean canExtractItem(int slot, int amount) {
        return this.canExtractItem(slot, amount, this.getStackInSlot(slot));
    }

    private boolean canExtractItem(int slot, int amount, @Nonnull ItemStack existing) {
        return this.extractFilter == null || this.extractFilter.canExtract(slot, amount, existing);
    }

    public static interface ExtractFilter {
        public boolean canExtract(int var1, int var2, @Nonnull ItemStack var3);
    }

    public static interface InputFilter {
        public boolean canInsert(int var1, ItemStack var2, @Nonnull ItemStack var3);
    }
}

