/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.tile;

import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileInventory
extends ItemStackHandler
implements Iterable<ItemStack> {
    protected final TileEntitySynchronized tile;
    protected final Consumer<Integer> changeListener;
    protected final Supplier<Integer> slotCountProvider;
    protected Set<Direction> applicableSides = new HashSet<Direction>();
    protected BiFunction<Integer, ItemStack, Integer> stackSizeLimiter;

    public TileInventory(@Nonnull TileEntitySynchronized tile, @Nonnull Supplier<Integer> slotCountProvider, Direction ... applicableSides) {
        this(tile, slotCountProvider, (Consumer<Integer>)null, applicableSides);
    }

    public TileInventory(@Nonnull TileEntitySynchronized tile, @Nonnull Supplier<Integer> slotCountProvider, @Nullable Consumer<Integer> changeListener, Direction ... applicableSides) {
        this(tile, slotCountProvider, changeListener, Arrays.asList(applicableSides), (Integer slot, ItemStack stack) -> stack.func_77976_d());
    }

    protected TileInventory(@Nonnull TileEntitySynchronized tile, @Nonnull Supplier<Integer> slotCountProvider, @Nullable Consumer<Integer> changeListener, @Nonnull Collection<Direction> applicableSides, @Nonnull BiFunction<Integer, ItemStack, Integer> stackSizeLimiter) {
        super(slotCountProvider.get().intValue());
        this.tile = tile;
        this.changeListener = changeListener;
        this.slotCountProvider = slotCountProvider;
        this.applicableSides.addAll(applicableSides);
        this.stackSizeLimiter = stackSizeLimiter;
    }

    public TileInventory filterMaxStackSize(BiFunction<Integer, ItemStack, Integer> stackSizeLimiter) {
        this.stackSizeLimiter = stackSizeLimiter;
        return this;
    }

    protected TileInventory makeNewInstance() {
        return new TileInventory(this.tile, this.slotCountProvider, this.changeListener, MiscUtils.copySet(this.applicableSides), this.stackSizeLimiter);
    }

    @Nonnull
    public TileInventory deserialize(CompoundNBT tag) {
        this.deserializeNBT(tag);
        if (this.getSlots() != this.slotCountProvider.get().intValue()) {
            TileInventory newInv = this.makeNewInstance();
            for (int i = 0; i < Math.min(this.getSlots(), newInv.getSlots()); ++i) {
                ItemStack old = this.getStackInSlot(i);
                old = ItemUtils.copyStackWithSize(old, old.func_190916_E());
                newInv.setStackInSlot(i, old);
            }
            return newInv;
        }
        return this;
    }

    @Nonnull
    public CompoundNBT serialize() {
        return this.serializeNBT();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int insertable = this.stackSizeLimiter.apply(slot, stack);
        int leftOver = stack.func_190916_E() - insertable;
        ItemStack toInsert = ItemUtils.copyStackWithSize(stack, insertable);
        ItemStack notInserted = super.insertItem(slot, toInsert, simulate);
        return ItemUtils.copyStackWithSize(toInsert, leftOver + notInserted.func_190916_E());
    }

    private boolean hasHandlerForSide(@Nullable Direction facing) {
        return facing == null || this.applicableSides.contains(facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable Direction facing) {
        return this.hasHandlerForSide(facing) && CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability;
    }

    public LazyOptional<TileInventory> getCapability() {
        return LazyOptional.of(() -> this);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.changeListener != null) {
            this.changeListener.accept(slot);
        }
        this.tile.markForUpdate();
    }

    public void clearInventory() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.setStackInSlot(i, ItemStack.field_190927_a);
            this.onContentsChanged(i);
        }
    }

    @Override
    @Nonnull
    public Iterator<ItemStack> iterator() {
        return this.stacks.iterator();
    }
}

