/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.tick;

import hellfirepvp.astralsorcery.common.util.tick.TokenMap;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.event.TickEvent;

public class TickTokenMap<K, V extends TickMapToken<?>>
extends TokenMap<K, V>
implements ITickHandler {
    private final EnumSet<TickEvent.Type> tickTypes;

    public TickTokenMap(@Nonnull TickEvent.Type first, TickEvent.Type ... restTypes) {
        this.tickTypes = EnumSet.of(first, restTypes);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        Iterator iteratorEntries = this.entrySet().iterator();
        while (iteratorEntries.hasNext()) {
            Map.Entry entry = iteratorEntries.next();
            ((TickMapToken)entry.getValue()).tick();
            if (((TickMapToken)entry.getValue()).getRemainingTimeout() > 0) continue;
            ((TickMapToken)entry.getValue()).onTimeout();
            iteratorEntries.remove();
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return this.tickTypes;
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "TickTokenMap";
    }

    public static interface TickMapToken<E>
    extends TokenMap.MapToken<E> {
        public int getRemainingTimeout();

        public void tick();

        public void onTimeout();
    }

    public static class SimpleTickToken<E>
    implements TickMapToken<E> {
        @Nonnull
        private E value;
        private int timeout;

        public SimpleTickToken(@Nonnull E value, int initialTimeout) {
            this.value = value;
            this.timeout = initialTimeout;
        }

        @Override
        public int getRemainingTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void addToTimeout(int timeout) {
            this.timeout += timeout;
        }

        @Override
        public void tick() {
            --this.timeout;
        }

        @Override
        public void onTimeout() {
        }

        @Override
        @Nonnull
        public E getValue() {
            return this.value;
        }

        public void setValue(@Nonnull E value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleTickToken that = (SimpleTickToken)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

