/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;

public interface ReadWriteLockable {
    public ReadWriteLock getLock();

    default public <T> T write(Supplier<T> fn) {
        return this.lock(this.getLock()::writeLock, fn);
    }

    default public void write(Runnable run) {
        this.lock(this.getLock()::writeLock, MiscUtils.nullSupplier(run));
    }

    default public <T> T read(Supplier<T> fn) {
        return this.lock(this.getLock()::readLock, fn);
    }

    default public void read(Runnable run) {
        this.lock(this.getLock()::readLock, MiscUtils.nullSupplier(run));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T lock(Supplier<Lock> lock, Supplier<T> fn) {
        lock.get().lock();
        try {
            T t = fn.get();
            return t;
        }
        finally {
            lock.get().unlock();
        }
    }
}

