/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.block.base.BlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.starlight.network.handler.BlockTransmutationHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StarlightNetworkRegistry {
    private static final List<IStarlightBlockHandler> blockHandlers = new LinkedList<IStarlightBlockHandler>();

    @Nullable
    public static IStarlightBlockHandler getStarlightHandler(World world, BlockPos pos, BlockState state, IWeakConstellation cst) {
        Block b = state.func_177230_c();
        if (b instanceof BlockStarlightRecipient) {
            return null;
        }
        for (IStarlightBlockHandler handler : blockHandlers) {
            if (!handler.isApplicable(world, pos, state, cst)) continue;
            return handler;
        }
        return null;
    }

    public static void registerBlockHandler(IStarlightBlockHandler handler) {
        blockHandlers.add(handler);
    }

    public static void setupRegistry() {
        StarlightNetworkRegistry.registerBlockHandler(new BlockTransmutationHandler());
    }

    public static interface IStarlightBlockHandler {
        public boolean isApplicable(World var1, BlockPos var2, BlockState var3, IWeakConstellation var4);

        public void receiveStarlight(World var1, Random var2, BlockPos var3, BlockState var4, IWeakConstellation var5, double var6);
    }
}

