/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.text.DecimalFormat;
import java.util.Locale;
import net.minecraft.entity.ai.attributes.AttributeModifier;

public enum ModifierType {
    ADDITION,
    ADDED_MULTIPLY,
    STACKING_MULTIPLY;

    private static final DecimalFormat DISPLAY_NUMBER_FORMAT;

    public static ModifierType fromVanillaAttributeOperation(AttributeModifier.Operation op) {
        return MiscUtils.getEnumEntry(ModifierType.class, op.func_220371_a());
    }

    public AttributeModifier.Operation getVanillaAttributeOperation() {
        return AttributeModifier.Operation.values()[this.ordinal()];
    }

    public String stringifyValue(float number) {
        if (this == ADDITION) {
            String str = DISPLAY_NUMBER_FORMAT.format(number);
            if (number > 0.0f) {
                str = "+" + str;
            }
            return str;
        }
        int nbr = Math.round(number * 100.0f);
        return DISPLAY_NUMBER_FORMAT.format(Math.abs(this == STACKING_MULTIPLY ? 100 - nbr : nbr));
    }

    public String getUnlocalizedModifierName(float number) {
        boolean positive;
        if (this == ADDITION) {
            positive = number > 0.0f;
        } else {
            int nbr = Math.round(number * 100.0f);
            positive = this == STACKING_MULTIPLY ? nbr > 100 : nbr > 0;
        }
        return this.getUnlocalizedModifierName(positive);
    }

    public String getUnlocalizedModifierName(boolean positive) {
        String base = positive ? "perk.modifier.astralsorcery.%s.add" : "perk.modifier.astralsorcery.%s.sub";
        return String.format(base, this.name().toLowerCase(Locale.ROOT));
    }

    static {
        DISPLAY_NUMBER_FORMAT = new DecimalFormat("0.##");
    }
}

