/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.modifier.AttributeModifierCritChance;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeCritChance
extends PerkAttributeType {
    public AttributeTypeCritChance() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_CRIT_CHANCE);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(EventPriority.HIGH, this::onArrowCrit);
        eventBus.addListener(EventPriority.LOW, this::onHitCrit);
    }

    @Override
    @Nonnull
    public PerkAttributeModifier createModifier(float modifier, ModifierType mode) {
        return new AttributeModifierCritChance(this, mode, modifier);
    }

    private void onArrowCrit(EntityJoinWorldEvent event) {
        ArrowEntity arrow;
        Entity shooter;
        if (event.getEntity() instanceof ArrowEntity && (shooter = (arrow = (ArrowEntity)event.getEntity()).func_234616_v_()) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)shooter;
            LogicalSide side = this.getSide((Entity)player);
            if (!this.hasTypeApplied(player, side)) {
                return;
            }
            float critChance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, 0.0f);
            critChance = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, critChance);
            if ((critChance /= 100.0f) >= rand.nextFloat()) {
                arrow.func_70243_d(true);
            }
        }
    }

    private void onHitCrit(CriticalHitEvent event) {
        LogicalSide side;
        if (event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        float critChance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, 0.0f);
        critChance = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, critChance);
        if ((critChance /= 100.0f) >= rand.nextFloat()) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

