/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyDamageArmor
extends KeyPerk {
    private static final float defaultDamagePerArmor = 0.05f;
    public static final Config CONFIG = new Config("key.damage_armor");

    public KeyDamageArmor(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.LOW, this::onDamage);
    }

    private void onDamage(LivingHurtEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        LivingEntity attacked = event.getEntityLiving();
        if (attacked instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)attacked, side = this.getSide((Entity)player))).getPerkData().hasPerkEffect(this)) {
            int armorPieces = 0;
            for (ItemStack armor : player.func_184193_aE()) {
                if (armor.func_190926_b()) continue;
                ++armorPieces;
            }
            if (armorPieces == 0) {
                return;
            }
            double dmgArmor = (Double)CONFIG.damagePerArmor.get();
            float dmg = event.getAmount();
            dmg = (float)((double)dmg * (dmgArmor * (double)armorPieces * (double)PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT)));
            event.setAmount(Math.max(event.getAmount() - dmg, 0.0f));
            int armorDmg = MathHelper.func_76123_f((float)(dmg * 1.3f));
            for (ItemStack stack : player.func_184193_aE()) {
                stack.func_222118_a(armorDmg, (LivingEntity)player, pl -> pl.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue damagePerArmor;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.damagePerArmor = cfgBuilder.comment("Defines how much damage is dealt additionally to armor. This value gets multiplied by the amount of armorpieces the entity you're attacking wears.").translation(this.translationKey("damagePerArmor")).defineInRange("damagePerArmor", (double)0.05f, (double)0.01f, (double)0.2f);
        }
    }
}

