/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerPerkData;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.data.research.ResearchSyncHelper;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncKnowledge
extends ASPacket<PktSyncKnowledge> {
    public static final byte STATE_ADD = 0;
    public static final byte STATE_WIPE = 1;
    private byte state;
    public List<ResourceLocation> knownConstellations = new ArrayList<ResourceLocation>();
    public List<ResourceLocation> seenConstellations = new ArrayList<ResourceLocation>();
    public List<ResourceLocation> storedConstellationPapers = new ArrayList<ResourceLocation>();
    public Collection<ResearchProgression> researchProgression = new ArrayList<ResearchProgression>();
    public IMajorConstellation attunedConstellation = null;
    public boolean wasOnceAttuned = false;
    public int progressTier = 0;
    public boolean doPerkAbilities = true;
    public PlayerPerkData perkData = null;

    public PktSyncKnowledge() {
    }

    public PktSyncKnowledge(byte state) {
        this.state = state;
    }

    public void load(PlayerProgress progress) {
        this.knownConstellations = progress.getKnownConstellations();
        this.seenConstellations = progress.getSeenConstellations();
        this.storedConstellationPapers = progress.getStoredConstellationPapers();
        this.researchProgression = progress.getResearchProgression();
        this.progressTier = progress.getTierReached().ordinal();
        this.attunedConstellation = progress.getAttunedConstellation();
        this.perkData = progress.getPerkData();
        this.wasOnceAttuned = progress.wasOnceAttuned();
        this.doPerkAbilities = progress.doPerkAbilities();
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncKnowledge> encoder() {
        return (packet, buffer) -> {
            buffer.writeByte((int)packet.state);
            ByteBufUtils.writeOptional(buffer, packet.perkData, (buf, perkData) -> perkData.write((PacketBuffer)buf));
            ByteBufUtils.writeCollection(buffer, packet.knownConstellations, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeCollection(buffer, packet.seenConstellations, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeCollection(buffer, packet.storedConstellationPapers, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeCollection(buffer, packet.researchProgression, ByteBufUtils::writeEnumValue);
            ByteBufUtils.writeOptional(buffer, packet.attunedConstellation, ByteBufUtils::writeRegistryEntry);
            buffer.writeBoolean(packet.wasOnceAttuned);
            buffer.writeInt(packet.progressTier);
            buffer.writeBoolean(packet.doPerkAbilities);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncKnowledge> decoder() {
        return buffer -> {
            PktSyncKnowledge pkt = new PktSyncKnowledge(buffer.readByte());
            pkt.perkData = ByteBufUtils.readOptional(buffer, buf -> PlayerPerkData.read(buf, LogicalSide.CLIENT));
            pkt.knownConstellations = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.seenConstellations = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.storedConstellationPapers = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.researchProgression = ByteBufUtils.readList(buffer, buf -> ByteBufUtils.readEnumValue(buf, ResearchProgression.class));
            pkt.attunedConstellation = ByteBufUtils.readOptional(buffer, ByteBufUtils::readRegistryEntry);
            pkt.wasOnceAttuned = buffer.readBoolean();
            pkt.progressTier = buffer.readInt();
            pkt.doPerkAbilities = buffer.readBoolean();
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncKnowledge> handler() {
        return new ASPacket.Handler<PktSyncKnowledge>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncKnowledge packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        if (packet.state == 0) {
                            ResearchSyncHelper.recieveProgressFromServer(packet, (PlayerEntity)player);
                        } else {
                            ResearchHelper.updateClientResearch(null);
                        }
                    }
                });
            }

            @Override
            public void handle(PktSyncKnowledge packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

