/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.jei;

import com.google.common.collect.ImmutableList;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.integration.IntegrationJEI;
import hellfirepvp.astralsorcery.common.integration.jei.JEICategory;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;

public class CategoryInfuser
extends JEICategory<LiquidInfusion> {
    private final IDrawable background;
    private final IDrawable icon;

    public CategoryInfuser(IGuiHelper guiHelper) {
        super(IntegrationJEI.CATEGORY_INFUSER);
        this.background = guiHelper.createDrawable(AstralSorcery.key("textures/gui/jei/infuser.png"), 0, 0, 116, 162);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlocksAS.INFUSER));
    }

    public Class<? extends LiquidInfusion> getRecipeClass() {
        return LiquidInfusion.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public List<LiquidInfusion> getRecipes() {
        return RecipeTypesAS.TYPE_INFUSION.getAllRecipes();
    }

    public void setIngredients(LiquidInfusion liquidInfusion, IIngredients ingredients) {
        ImmutableList.Builder fluidInputs = ImmutableList.builder();
        ImmutableList.Builder itemInputs = ImmutableList.builder();
        ImmutableList.Builder itemOutputs = ImmutableList.builder();
        itemInputs.add(Arrays.asList(liquidInfusion.getItemInput().func_193365_a()));
        itemOutputs.add(Collections.singletonList(liquidInfusion.getOutputForRender(Collections.emptyList())));
        FluidStack fInput = new FluidStack(liquidInfusion.getLiquidInput(), 1000);
        for (int i = 0; i < 12; ++i) {
            fluidInputs.add(Collections.singletonList(fInput.copy()));
        }
        ingredients.setInputLists(VanillaTypes.FLUID, (List)fluidInputs.build());
        ingredients.setInputLists(VanillaTypes.ITEM, (List)itemInputs.build());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)itemOutputs.build());
    }

    public void setRecipe(IRecipeLayout recipeLayout, LiquidInfusion liquidInfusion, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        itemStacks.init(0, true, 49, 95);
        CategoryInfuser.initFluidInput(fluidStacks, 1, 30, 57);
        CategoryInfuser.initFluidInput(fluidStacks, 2, 49, 57);
        CategoryInfuser.initFluidInput(fluidStacks, 3, 68, 57);
        CategoryInfuser.initFluidInput(fluidStacks, 4, 11, 76);
        CategoryInfuser.initFluidInput(fluidStacks, 5, 87, 76);
        CategoryInfuser.initFluidInput(fluidStacks, 6, 11, 95);
        CategoryInfuser.initFluidInput(fluidStacks, 7, 87, 95);
        CategoryInfuser.initFluidInput(fluidStacks, 8, 11, 114);
        CategoryInfuser.initFluidInput(fluidStacks, 9, 87, 114);
        CategoryInfuser.initFluidInput(fluidStacks, 10, 30, 133);
        CategoryInfuser.initFluidInput(fluidStacks, 11, 49, 133);
        CategoryInfuser.initFluidInput(fluidStacks, 12, 68, 133);
        itemStacks.init(13, false, 48, 18);
        itemStacks.set(ingredients);
        fluidStacks.set(ingredients);
    }
}

