/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.common.block.tile.BlockAltar;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.integration.jei.JEICategory;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CategoryAltar
extends JEICategory<SimpleAltarRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final AltarType altarType;

    public CategoryAltar(ResourceLocation id, String textureRef, BlockAltar altarRef, IGuiHelper guiHelper) {
        super(id);
        this.background = guiHelper.createDrawable(AstralSorcery.key(String.format("textures/gui/jei/%s.png", textureRef)), 0, 0, 116, 162);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)altarRef));
        this.altarType = altarRef.getAltarType();
    }

    public Class<? extends SimpleAltarRecipe> getRecipeClass() {
        return SimpleAltarRecipe.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public AltarType getAltarType() {
        return this.altarType;
    }

    @Override
    public List<SimpleAltarRecipe> getRecipes() {
        return RecipeTypesAS.TYPE_ALTAR.getRecipes(recipe -> recipe.getAltarType().equals((Object)this.getAltarType()));
    }

    public void draw(SimpleAltarRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getFocusConstellation() != null) {
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            IConstellation cst = recipe.getFocusConstellation();
            RenderingConstellationUtils.renderConstellationIntoGUI(Color.BLACK, cst, matrixStack, 0.0f, 0.0f, 0.0f, 50.0f, 50.0f, 1.2f, () -> Float.valueOf(0.9f), true, false);
            RenderSystem.disableBlend();
        }
    }

    public void setIngredients(SimpleAltarRecipe altarRecipe, IIngredients ingredients) {
        ImmutableList.Builder itemInputs = ImmutableList.builder();
        ImmutableList.Builder itemOutputs = ImmutableList.builder();
        itemOutputs.add(Collections.singletonList(altarRecipe.getOutputForRender(Collections.emptyList())));
        AltarRecipeGrid grid = altarRecipe.getInputs();
        for (int slot = 0; slot < 25; ++slot) {
            itemInputs.add(CategoryAltar.ingredientStacks(grid.getIngredient(slot)));
        }
        for (WrappedIngredient relayInput : altarRecipe.getRelayInputs()) {
            itemInputs.add(CategoryAltar.ingredientStacks(relayInput.getIngredient()));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, (List)itemInputs.build());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)itemOutputs.build());
    }

    public void setRecipe(IRecipeLayout recipeLayout, SimpleAltarRecipe altarRecipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        int step = 19;
        int xOffset = 11;
        int yOffset = 57;
        for (int yy = 0; yy < 5; ++yy) {
            for (int xx = 0; xx < 5; ++xx) {
                int slot = xx + yy * 5;
                itemStacks.init(slot, true, xOffset + step * xx, yOffset + step * yy);
            }
        }
        int centerX = 49;
        int centerY = 95;
        int additional = altarRecipe.getRelayInputs().size();
        for (int i = 0; i < additional; ++i) {
            double part = (double)i / (double)additional * 2.0 * Math.PI;
            part = MathHelper.func_151237_a((double)part, (double)0.0, (double)(Math.PI * 2));
            double xAdd = Math.sin(part += Math.PI) * 60.0;
            double yAdd = Math.cos(part) * 60.0;
            itemStacks.init(25 + i, true, MathHelper.func_76128_c((double)((double)centerX + xAdd)), MathHelper.func_76128_c((double)((double)centerY + yAdd)));
        }
        itemStacks.init(itemStacks.getGuiIngredients().size(), false, 48, 18);
        itemStacks.set(ingredients);
    }
}

