/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.helper;

import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.util.block.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.tick.TickTokenMap;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;

public class EventHelperSpawnDeny {
    public static TickTokenMap<WorldBlockPos, TickTokenMap.SimpleTickToken<Double>> spawnDenyRegions = new TickTokenMap(TickEvent.Type.SERVER, new TickEvent.Type[0]);

    public static void clearServer() {
        spawnDenyRegions.clear();
    }

    public static void attachTickListener(Consumer<ITickHandler> registrar) {
        registrar.accept(spawnDenyRegions);
    }

    public static void attachListeners(IEventBus eventBus) {
        eventBus.addListener(EventHelperSpawnDeny::onSpawn);
    }

    private static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.DENY || event.getWorld().func_201670_d() || event.getSpawner() != null) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_184216_O().contains("skip.spawn.deny")) {
            return;
        }
        if (((Boolean)GeneralConfig.CONFIG.mobSpawningDenyAllTypes.get()).booleanValue() || entity.getClassification(false) == EntityClassification.MONSTER) {
            Vector3 entityPos = Vector3.atEntityCorner((Entity)entity);
            for (Map.Entry entry : spawnDenyRegions.entrySet()) {
                if (!((WorldBlockPos)((Object)entry.getKey())).getWorldKey().equals((Object)entity.func_130014_f_().func_234923_W_()) || !(entityPos.distance((Vector3i)entry.getKey()) <= (Double)((TickTokenMap.SimpleTickToken)entry.getValue()).getValue())) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }
}

