/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXRenderOffsetFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXScaleFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.util.data.ASDataSerializers;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityShootingStar
extends ThrowableEntity {
    private static final DataParameter<Long> EFFECT_SEED = EntityDataManager.func_187226_a(EntityShootingStar.class, ASDataSerializers.LONG);

    protected EntityShootingStar(World worldIn) {
        super(EntityTypesAS.SHOOTING_STAR, worldIn);
        this.field_70180_af.func_187227_b(EFFECT_SEED, (Object)this.field_70146_Z.nextLong());
    }

    protected EntityShootingStar(double x, double y, double z, World worldIn) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public static EntityType.IFactory<EntityShootingStar> factory() {
        return (type, world) -> new EntityShootingStar(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EFFECT_SEED, (Object)0L);
    }

    public long getEffectSeed() {
        return (Long)this.field_70180_af.func_187225_a(EFFECT_SEED);
    }

    public void func_70071_h_() {
        this.adjustMotion();
        super.func_70071_h_();
        if (this.field_70170_p.func_201670_d()) {
            this.spawnEffects();
        }
    }

    private void adjustMotion() {
        Vector3d motion = this.func_213322_ci();
        double y = Math.min((double)-0.7f, motion.func_82617_b());
        this.func_213317_d(new Vector3d(motion.func_82615_a(), y, motion.func_82616_c()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnEffects() {
        float maxRenderPosDist = 96.0f;
        VFXRenderOffsetFunction<FXFacingParticle> renderFn = (fx, iPos, pTicks) -> {
            ClientPlayerEntity pl = Minecraft.func_71410_x().field_71439_g;
            if (pl == null) {
                return iPos;
            }
            Vector3 v = fx.getPosition().clone().subtract(Vector3.atEntityCorner((Entity)pl));
            if (v.length() <= (double)maxRenderPosDist) {
                return iPos;
            }
            return Vector3.atEntityCorner((Entity)pl).add(v.normalize().multiply(maxRenderPosDist));
        };
        VFXScaleFunction<EntityVisualFX> scaleFn = (fx, scaleIn, pTicks) -> {
            ClientPlayerEntity pl = Minecraft.func_71410_x().field_71439_g;
            if (pl == null) {
                return scaleIn;
            }
            Vector3 v = fx.getPosition().clone().subtract(Vector3.atEntityCorner((Entity)pl));
            float mul = v.length() <= (double)maxRenderPosDist ? 1.0f : (float)((double)maxRenderPosDist / v.length());
            return scaleIn * 0.25f + (mul * scaleIn - scaleIn * 0.25f);
        };
        Vector3 thisPosition = Vector3.atEntityCorner((Entity)this);
        for (int i = 0; i < 4; ++i) {
            if (this.field_70146_Z.nextFloat() > 0.75f) continue;
            Vector3 dir = new Vector3(this.func_213322_ci()).clone().multiply(this.field_70146_Z.nextFloat() * -0.6f);
            dir.setX(dir.getX() + (double)this.field_70146_Z.nextFloat() * 0.008 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
            dir.setZ(dir.getZ() + (double)this.field_70146_Z.nextFloat() * 0.008 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(thisPosition)).color(VFXColorFunction.WHITE)).setMotion(dir)).setAlphaMultiplier(0.85f)).setScaleMultiplier(1.2f + this.field_70146_Z.nextFloat() * 0.5f)).scale(VFXScaleFunction.SHRINK.andThen(scaleFn))).alpha(VFXAlphaFunction.FADE_OUT)).renderOffset(renderFn)).setMaxAge(90 + this.field_70146_Z.nextInt(40));
        }
        float scale = 4.0f + this.field_70146_Z.nextFloat() * 3.0f;
        int age = 5 + this.field_70146_Z.nextInt(2);
        Random effectSeed = new Random(this.getEffectSeed());
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(thisPosition)).color(VFXColorFunction.constant(Color.getHSBColor(effectSeed.nextFloat() * 360.0f, 1.0f, 1.0f)))).setScaleMultiplier(scale)).scale(VFXScaleFunction.SHRINK.andThen(scaleFn))).renderOffset(renderFn)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(age);
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(thisPosition)).color(VFXColorFunction.WHITE)).setScaleMultiplier(scale * 0.6f)).scale(VFXScaleFunction.SHRINK.andThen(scaleFn))).renderOffset(renderFn)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(Math.round((float)age * 1.5f));
    }

    public void func_70107_b(double x, double y, double z) {
        int chunkX = MathHelper.func_76128_c((double)(this.func_226277_ct_() / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() / 16.0));
        int newChunkX = MathHelper.func_76128_c((double)(x / 16.0));
        int newChunkZ = MathHelper.func_76128_c((double)(z / 16.0));
        if (!(chunkX == newChunkX && chunkZ == newChunkZ || this.func_130014_f_().func_217354_b(newChunkX, newChunkZ))) {
            this.func_70106_y();
            return;
        }
        super.func_70107_b(x, y, z);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

