/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.effect;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.resource.query.SpriteQuery;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;

public abstract class EffectCustomTexture
extends Effect {
    protected static final Random rand = new Random();
    private final Color colorAsObj;

    public EffectCustomTexture(EffectType type, Color color) {
        super(type, color.getRGB());
        this.colorAsObj = color;
    }

    public void attachEventListeners(IEventBus bus) {
    }

    public abstract SpriteQuery getSpriteQuery();

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack renderStack, int x, int y, float z) {
        float wh = 18.0f;
        float offsetX = x + 6;
        float offsetY = y + 7;
        float red = (float)this.colorAsObj.getRed() / 255.0f;
        float green = (float)this.colorAsObj.getGreen() / 255.0f;
        float blue = (float)this.colorAsObj.getBlue() / 255.0f;
        SpriteSheetResource ssr = this.getSpriteQuery().resolveSprite();
        ssr.bindTexture();
        Tuple<Float, Float> uvTpl = ssr.getUVOffset(ClientScheduler.getClientTick());
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, offsetX, offsetY, z, wh, wh).color(red, green, blue, 1.0f).tex(((Float)uvTpl.func_76341_a()).floatValue(), ((Float)uvTpl.func_76340_b()).floatValue(), ssr.getUWidth(), ssr.getVWidth()).draw());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, MatrixStack renderStack, int x, int y, float z, float alpha) {
        float wh = 18.0f;
        float offsetX = x + 3;
        float offsetY = y + 3;
        float red = (float)this.colorAsObj.getRed() / 255.0f;
        float green = (float)this.colorAsObj.getGreen() / 255.0f;
        float blue = (float)this.colorAsObj.getBlue() / 255.0f;
        SpriteSheetResource ssr = this.getSpriteQuery().resolveSprite();
        ssr.bindTexture();
        Tuple<Float, Float> uvTpl = ssr.getUVOffset(ClientScheduler.getClientTick());
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, offsetX, offsetY, z, wh, wh).color(red, green, blue, 1.0f).tex(((Float)uvTpl.func_76341_a()).floatValue(), ((Float)uvTpl.func_76340_b()).floatValue(), ssr.getUWidth(), ssr.getVWidth()).draw());
    }
}

