/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.IExtensibleEnum;

public enum ResearchProgression implements IExtensibleEnum
{
    DISCOVERY(ProgressionTier.DISCOVERY, new ResearchProgression[0]),
    BASIC_CRAFT(ProgressionTier.BASIC_CRAFT, DISCOVERY),
    ATTUNEMENT(ProgressionTier.ATTUNEMENT, BASIC_CRAFT),
    CONSTELLATION(ProgressionTier.CONSTELLATION_CRAFT, ATTUNEMENT),
    RADIANCE(ProgressionTier.TRAIT_CRAFT, CONSTELLATION),
    BRILLIANCE(ProgressionTier.BRILLIANCE, RADIANCE);

    private final List<ResearchProgression> preConditions = new LinkedList<ResearchProgression>();
    private final List<ResearchNode> researchNodes = new LinkedList<ResearchNode>();
    private final ProgressionTier requiredProgress;
    private final String unlocName;

    private ResearchProgression(ProgressionTier requiredProgress, ResearchProgression ... preConditions) {
        this(requiredProgress, Arrays.asList(preConditions));
    }

    private ResearchProgression(ProgressionTier requiredProgress, List<ResearchProgression> preConditions) {
        this.preConditions.addAll(preConditions);
        this.requiredProgress = requiredProgress;
        this.unlocName = "astralsorcery.journal.research." + this.name().toLowerCase(Locale.ROOT);
    }

    public Consumer<ResearchNode> getRegistrar() {
        return this::addResearchToGroup;
    }

    void addResearchToGroup(ResearchNode res) {
        for (ResearchNode node : this.researchNodes) {
            if (node.renderPosX != res.renderPosX || node.renderPosZ != res.renderPosZ) continue;
            throw new IllegalArgumentException("Tried to register 2 Research Nodes at the same position at x=" + res.renderPosX + ", z=" + res.renderPosZ + "! Present: " + node.getKey() + " - Tried to set: " + res.getKey());
        }
        this.researchNodes.add(res);
    }

    public static ResearchProgression create(String name, ProgressionTier tier, List<ResearchProgression> preConditions) {
        throw new IllegalStateException("Enum not extended");
    }

    public List<ResearchNode> getResearchNodes() {
        return this.researchNodes;
    }

    public ProgressionTier getRequiredProgress() {
        return this.requiredProgress;
    }

    public List<ResearchProgression> getPreConditions() {
        return Collections.unmodifiableList(this.preConditions);
    }

    public ITextComponent getName() {
        return new TranslationTextComponent(this.unlocName);
    }

    @Nullable
    public static ResearchNode findNode(String name) {
        for (ResearchProgression prog : ResearchProgression.values()) {
            for (ResearchNode node : prog.getResearchNodes()) {
                if (!node.getKey().equals(name)) continue;
                return node;
            }
        }
        return null;
    }

    @Nonnull
    public static Collection<ResearchProgression> findProgression(ResearchNode n) {
        ArrayList progressions = Lists.newArrayList();
        for (ResearchProgression prog : ResearchProgression.values()) {
            if (!prog.getResearchNodes().contains(n)) continue;
            progressions.add(prog);
        }
        return progressions;
    }
}

