/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.starlight;

import hellfirepvp.astralsorcery.common.crafting.nojson.CustomRecipe;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class LiquidStarlightRecipe
extends CustomRecipe {
    protected static final Random rand = new Random();
    private static final int WORLD_TIME_TOLERANCE = 10;

    public LiquidStarlightRecipe(ResourceLocation key) {
        super(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<Ingredient> getInputForRender();

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<Ingredient> getOutputForRender();

    public abstract boolean doesStartRecipe(ItemStack var1);

    public abstract boolean matches(ItemEntity var1, World var2, BlockPos var3);

    public abstract void doServerCraftTick(ItemEntity var1, World var2, BlockPos var3);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void doClientEffectTick(ItemEntity var1, World var2, BlockPos var3);

    protected final List<Entity> getEntitiesInBlock(IWorld world, BlockPos pos) {
        return world.func_217357_a(Entity.class, new AxisAlignedBB(pos));
    }

    @Nullable
    protected final ItemStack consumeItemEntityInBlock(IWorld world, BlockPos pos, Item itemClass) {
        return this.consumeItemEntityInBlock(world, pos, 1, stack -> itemClass.getClass().isAssignableFrom(stack.func_77973_b().getClass()));
    }

    @Nullable
    protected final ItemStack consumeItemEntityInBlock(IWorld world, BlockPos pos, int count, Predicate<ItemStack> match) {
        List entities = this.getEntitiesInBlock(world, pos).stream().filter(e -> e instanceof ItemEntity).collect(Collectors.toList());
        for (Entity e2 : entities) {
            ItemEntity ie = (ItemEntity)e2;
            if (!ie.func_70089_S() || ie.func_92059_d().func_190926_b() || ie.func_92059_d().func_190916_E() < count || !match.test(ie.func_92059_d())) continue;
            ItemStack stored = ie.func_92059_d();
            ItemStack found = ItemUtils.copyStackWithSize(stored, count);
            stored.func_190918_g(count);
            ie.func_92058_a(stored);
            return found;
        }
        return null;
    }

    protected final int getAndIncrementCraftingTick(Entity e) {
        int tick = this.getCraftingTick(e);
        this.setCraftingTick(e, tick + 1);
        return tick;
    }

    protected final void setCraftingTick(Entity e, int tick) {
        long wTick = e.func_130014_f_().func_82737_E();
        CompoundNBT nbt = NBTHelper.getPersistentData(e);
        nbt.func_74768_a("craftTick", tick);
        nbt.func_74772_a("wCraftTick", wTick);
    }

    protected final int getCraftingTick(Entity e) {
        long wTick = e.func_130014_f_().func_82737_E();
        CompoundNBT nbt = NBTHelper.getPersistentData(e);
        if (!nbt.func_150297_b("wCraftTick", 4)) {
            return 0;
        }
        long savedWTick = nbt.func_74763_f("wCraftTick");
        if (Math.abs(wTick - savedWTick) > 10L) {
            return 0;
        }
        return nbt.func_74762_e("craftTick");
    }
}

