/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.attunement;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.nojson.attunement.active.ActivePlayerAttunementRecipe;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class AttunePlayerRecipe
extends AttunementRecipe<ActivePlayerAttunementRecipe> {
    private static final AxisAlignedBB BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public AttunePlayerRecipe() {
        super(AstralSorcery.key("attune_player"));
    }

    @Override
    public boolean canStartCrafting(TileAttunementAltar altar) {
        World world = altar.func_145831_w();
        if (DayTimeHelper.isNight(world)) {
            return AttunePlayerRecipe.findEligiblePlayer(altar) != null;
        }
        return false;
    }

    @Override
    @Nonnull
    public ActivePlayerAttunementRecipe createRecipe(TileAttunementAltar altar) {
        ServerPlayerEntity player = AttunePlayerRecipe.findEligiblePlayer(altar);
        return new ActivePlayerAttunementRecipe(this, (IMajorConstellation)altar.getActiveConstellation(), player.func_110124_au());
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ActivePlayerAttunementRecipe deserialize(TileAttunementAltar altar, CompoundNBT nbt, @Nullable ActivePlayerAttunementRecipe previousInstance) {
        ActivePlayerAttunementRecipe recipe = new ActivePlayerAttunementRecipe(this, nbt);
        if (previousInstance != null) {
            recipe.cameraHack = previousInstance.cameraHack;
        }
        return recipe;
    }

    @Nullable
    private static ServerPlayerEntity findEligiblePlayer(TileAttunementAltar altar) {
        ServerPlayerEntity pl;
        if (!(altar.getActiveConstellation() instanceof IMajorConstellation)) {
            return null;
        }
        AxisAlignedBB boxAt = BOX.func_186670_a(altar.func_174877_v().func_177984_a()).func_186662_g(1.0);
        Vector3 thisVec = new Vector3(altar).add(0.5, 1.5, 0.5);
        List players = altar.func_145831_w().func_217357_a(ServerPlayerEntity.class, boxAt);
        if (!players.isEmpty() && AttunePlayerRecipe.isEligablePlayer(pl = EntityUtils.selectClosest(players, player -> thisVec.distanceSquared(player.func_213303_ch())), altar.getActiveConstellation())) {
            return pl;
        }
        return null;
    }

    public static boolean isEligablePlayer(ServerPlayerEntity player, IConstellation attuneTo) {
        if (player != null && player.func_70089_S() && !MiscUtils.isPlayerFakeMP(player) && !player.func_225608_bj_()) {
            PlayerProgress prog = ResearchHelper.getProgress((PlayerEntity)player, LogicalSide.SERVER);
            return prog.isValid() && attuneTo instanceof IMajorConstellation && !prog.isAttuned() && prog.getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT) && prog.hasConstellationDiscovered(attuneTo);
        }
        return false;
    }
}

