/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.builder;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeBuilder;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LiquidInfusionBuilder
extends CustomRecipeBuilder<LiquidInfusion> {
    private final ResourceLocation id;
    private Fluid liquidInput = null;
    private Ingredient itemInput = Ingredient.field_193370_a;
    private ItemStack output = ItemStack.field_190927_a;
    private int craftingTickTime = 200;
    private float consumptionChance = 0.3f;
    private boolean consumeMultipleFluids = false;
    private boolean acceptChaliceInput = true;
    private boolean copyNBTToOutputs = false;

    private LiquidInfusionBuilder(ResourceLocation id) {
        this.id = id;
    }

    public static LiquidInfusionBuilder builder(ForgeRegistryEntry<?> nameProvider) {
        return new LiquidInfusionBuilder(AstralSorcery.key(nameProvider.getRegistryName().func_110623_a()));
    }

    public static LiquidInfusionBuilder builder(ResourceLocation id) {
        return new LiquidInfusionBuilder(id);
    }

    public LiquidInfusionBuilder setLiquidInput(Fluid liquidInput) {
        this.liquidInput = liquidInput;
        return this;
    }

    public LiquidInfusionBuilder setItemInput(IItemProvider item) {
        this.itemInput = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        return this;
    }

    public LiquidInfusionBuilder setItemInput(ITag.INamedTag<Item> tag) {
        this.itemInput = Ingredient.func_199805_a(tag);
        return this;
    }

    public LiquidInfusionBuilder setItemInput(Ingredient input) {
        this.itemInput = input;
        return this;
    }

    public LiquidInfusionBuilder setOutput(IItemProvider output) {
        return this.setOutput(new ItemStack(output));
    }

    public LiquidInfusionBuilder setOutput(ItemStack output) {
        this.output = output.func_77946_l();
        return this;
    }

    public LiquidInfusionBuilder multiplyDuration(float multiplier) {
        this.craftingTickTime = (int)((float)this.craftingTickTime * multiplier);
        return this;
    }

    public LiquidInfusionBuilder setDuration(int craftingTickTime) {
        this.craftingTickTime = craftingTickTime;
        return this;
    }

    public LiquidInfusionBuilder setFluidConsumptionChance(float consumptionChance) {
        this.consumptionChance = consumptionChance;
        return this;
    }

    public LiquidInfusionBuilder setConsumeMultipleFluids(boolean consumeMultipleFluids) {
        this.consumeMultipleFluids = consumeMultipleFluids;
        return this;
    }

    public LiquidInfusionBuilder setAcceptChaliceInput(boolean acceptChaliceInput) {
        this.acceptChaliceInput = acceptChaliceInput;
        return this;
    }

    public LiquidInfusionBuilder setCopyNBTToOutputs(boolean copyNBTToOutputs) {
        this.copyNBTToOutputs = copyNBTToOutputs;
        return this;
    }

    @Override
    @Nonnull
    protected LiquidInfusion validateAndGet() {
        if (this.liquidInput == null) {
            throw new IllegalArgumentException("No fluid input defined!");
        }
        if (this.itemInput.func_203189_d()) {
            throw new IllegalArgumentException("No valid item for input found!");
        }
        if (this.output.func_190926_b()) {
            throw new IllegalArgumentException("No output item defined!");
        }
        if (this.craftingTickTime <= 0) {
            throw new IllegalArgumentException("No duration defined!");
        }
        return new LiquidInfusion(this.id, this.craftingTickTime, this.liquidInput, this.itemInput, this.output, this.consumptionChance, this.consumeMultipleFluids, this.acceptChaliceInput, this.copyNBTToOutputs);
    }

    @Override
    protected CustomRecipeSerializer<LiquidInfusion> getSerializer() {
        return RecipeSerializersAS.LIQUID_INFUSION_SERIALIZER;
    }
}

