/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.event.PlayerAffectionFlags;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ConstellationEffect {
    protected static final Random rand = new Random();
    protected static final AxisAlignedBB BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final IWeakConstellation cst;
    private final ILocatable pos;
    private boolean needsChunkToBeLoaded = false;

    protected ConstellationEffect(@Nonnull ILocatable origin, @Nonnull IWeakConstellation cst) {
        this.cst = cst;
        this.pos = origin;
    }

    protected void setChunkNeedsToBeLoaded() {
        this.needsChunkToBeLoaded = true;
    }

    public boolean needsChunkToBeLoaded() {
        return this.needsChunkToBeLoaded;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void playClientEffect(World var1, BlockPos var2, TileRitualPedestal var3, float var4, boolean var5);

    public abstract boolean playEffect(World var1, BlockPos var2, ConstellationEffectProperties var3, @Nullable IMinorConstellation var4);

    @Nullable
    public TileRitualPedestal getPedestal(World world, BlockPos pos) {
        TileRitualLink link;
        TileEntity te = MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, false);
        if (te instanceof TileRitualLink && (pos = (link = (TileRitualLink)te).getLinkedTo()) != null) {
            pos = pos.func_177973_b((Vector3i)TileRitualPedestal.RITUAL_ANCHOR_OFFEST);
            return MiscUtils.getTileAt((IBlockReader)world, pos, TileRitualPedestal.class, false);
        }
        return te instanceof TileRitualPedestal ? (TileRitualPedestal)te : null;
    }

    public ConstellationEffectProperties createProperties(int mirrors) {
        return new ConstellationEffectProperties((Double)this.getConfig().range.get() + (double)mirrors * (Double)this.getConfig().rangePerLens.get());
    }

    public abstract Config getConfig();

    public abstract PlayerAffectionFlags.AffectionFlag getPlayerAffectionFlag();

    protected static PlayerAffectionFlags.AffectionFlag makeAffectionFlag(String constellationName) {
        return new PlayerAffectionFlags.NoOpAffectionFlag(AstralSorcery.key("constellation_effect_" + constellationName));
    }

    @Nonnull
    public IWeakConstellation getConstellation() {
        return this.cst;
    }

    @Nonnull
    public ILocatable getPos() {
        return this.pos;
    }

    public void clearCache() {
    }

    public void readFromNBT(CompoundNBT cmp) {
    }

    public void writeToNBT(CompoundNBT cmp) {
    }

    @Nullable
    public PlayerEntity getOwningPlayerInWorld(World world, BlockPos pos) {
        TileRitualPedestal pedestal = this.getPedestal(world, pos);
        if (pedestal != null) {
            return pedestal.getOwner();
        }
        return null;
    }

    public void sendConstellationPing(World world, Vector3 at) {
        ConstellationEffect.sendConstellationPing(world, at, this.getConstellation());
    }

    public static void sendConstellationPing(World world, Vector3 at, IConstellation cst) {
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.CONSTELLATION_EFFECT_PING).addData(buf -> {
            ByteBufUtils.writeVector(buf, at);
            ByteBufUtils.writeRegistryEntry(buf, cst);
        });
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos(world, (Vector3i)at.toBlockPos(), 32.0));
    }

    protected void markPlayerAffected(PlayerEntity player) {
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        PlayerAffectionFlags.markPlayerAffected(player, this.getPlayerAffectionFlag());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playConstellationPing(PktPlayEffect pktPlayEffect) {
        Vector3 at = ByteBufUtils.readVector(pktPlayEffect.getExtraData());
        IConstellation cst = (IConstellation)ByteBufUtils.readRegistryEntry(pktPlayEffect.getExtraData());
        for (int i = 0; i < 6; ++i) {
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at.clone().add(Vector3.random().multiply(0.25f)))).setMotion(Vector3.random().multiply(0.015f))).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(cst.getConstellationColor().brighter()))).setScaleMultiplier(0.25f + rand.nextFloat() * 0.15f)).setMaxAge(35 + rand.nextInt(20));
        }
    }

    public static abstract class Config
    extends ConfigEntry {
        private final boolean defaultEnabled = true;
        private final double defaultRange;
        private final double defaultRangePerLens;
        public ForgeConfigSpec.BooleanValue enabled;
        public ForgeConfigSpec.DoubleValue range;
        public ForgeConfigSpec.DoubleValue rangePerLens;

        public Config(String constellationName, double defaultRange, double defaultRangePerLens) {
            super(String.format("constellation.effect.%s", constellationName));
            this.defaultRange = defaultRange;
            this.defaultRangePerLens = defaultRangePerLens;
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.enabled = cfgBuilder.comment("Set this to false to disable this ritual effect").translation(this.translationKey("enabled")).define("enabled", this.defaultEnabled);
            this.range = cfgBuilder.comment("Defines the radius (in blocks) in which the ritual will do its effects.").translation(this.translationKey("range")).defineInRange("range", this.defaultRange, 1.0, 512.0);
            this.rangePerLens = cfgBuilder.comment("Defines the increase in radius the ritual will get per active lens enhancing the ritual.").translation(this.translationKey("rangePerLens")).defineInRange("rangePerLens", this.defaultRangePerLens, 0.0, 128.0);
        }
    }
}

