/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonData;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectType;
import hellfirepvp.observerlib.common.util.tick.TickManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;

public class PatreonDataManager {
    private static final String PATREON_EFFECT_URL = "http://hellfiredev.net/patreon.json";
    private static final Gson GSON = new GsonBuilder().create();

    public static void loadPatreonEffects() {
        Thread tr = new Thread(() -> {
            PatreonData data;
            URLConnection conn;
            try {
                conn = new URL(PATREON_EFFECT_URL).openConnection();
            }
            catch (IOException e) {
                AstralSorcery.log.error("Failed to connect to patreon fileserver! Not loading patreon files...");
                e.printStackTrace();
                PatreonEffectHelper.loadingFinished = true;
                return;
            }
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                Object object = null;
                try {
                    data = (PatreonData)GSON.fromJson((Reader)br, PatreonData.class);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        if (object != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                AstralSorcery.log.error("Failed to connect to patreon fileserver! Not loading patreon files...");
                e.printStackTrace();
                PatreonEffectHelper.loadingFinished = true;
                return;
            }
            int skipped = 0;
            for (PatreonData.EffectEntry entry : data.getEffectList()) {
                PatreonEffectType type;
                UUID plUuid;
                try {
                    plUuid = UUID.fromString(entry.getUuid());
                    type = PatreonEffectType.valueOf(entry.getEffectClass());
                }
                catch (Exception exc) {
                    ++skipped;
                    continue;
                }
                try {
                    Object pe = type.getProvider().buildEffect(plUuid, entry.getParameters());
                    ((PatreonEffect)pe).initialize();
                    ((PatreonEffect)pe).attachEventListeners(MinecraftForge.EVENT_BUS);
                    ((PatreonEffect)pe).attachTickListeners(arg_0 -> ((TickManager)AstralSorcery.getProxy().getTickManager()).register(arg_0));
                    PatreonEffectHelper.playerEffectMap.computeIfAbsent(plUuid, uuid -> new ArrayList()).add(pe);
                    PatreonEffectHelper.effectMap.put(((PatreonEffect)pe).getEffectUUID(), (PatreonEffect)pe);
                }
                catch (Exception exc) {
                    ++skipped;
                }
            }
            if (skipped > 0) {
                AstralSorcery.log.warn("Skipped " + skipped + " patreon effects during loading due to malformed data!");
            }
            AstralSorcery.log.info("Patreon effect loading finished.");
            UUID hellfire = UUID.fromString("7f6971c5-fb58-4519-a975-b1b5766e92d1");
            PatreonEffectHelper.loadingFinished = true;
        });
        tr.setName("AstralSorcery Patreon Effect Loader");
        tr.start();
    }
}

