/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.registry;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.constellation.ConstellationRenderInfos;
import hellfirepvp.astralsorcery.client.lib.RenderTypesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.render.RenderStateBuilder;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.image.SkyImageGenerator;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Util;

public class RegistryRenderTypes {
    public static void init() {
        RegistryRenderTypes.initEffectTypes();
        RegistryRenderTypes.initEffects();
        RegistryRenderTypes.initConstellationTypes();
        RegistryRenderTypes.initGuiTypes();
        RegistryRenderTypes.initTERTypes();
        RegistryRenderTypes.initModels();
    }

    private static void initEffectTypes() {
        RenderTypesAS.EFFECT_FX_GENERIC_PARTICLE = RegistryRenderTypes.createType("effect_fx_generic_particle", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(TexturesAS.TEX_PARTICLE_SMALL).blend(Blending.DEFAULT).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_GENERIC_PARTICLE_DEPTH = RegistryRenderTypes.createType("effect_fx_generic_particle_depth", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(TexturesAS.TEX_PARTICLE_SMALL).blend(Blending.DEFAULT).disableCull().disableDepthMask().disableDepth().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_GENERIC_PARTICLE_ATLAS = RegistryRenderTypes.createType("effect_fx_generic_particle_atlas", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_LIGHTNING = RegistryRenderTypes.createType("effect_fx_lightning", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(TexturesAS.TEX_LIGHTNING_PART).blend(Blending.DEFAULT).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_LIGHTBEAM = RegistryRenderTypes.createType("effect_fx_lightbeam", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(TexturesAS.TEX_LIGHTBEAM).blend(Blending.ADDITIVE_ALPHA).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_CRYSTAL = RegistryRenderTypes.createType("effect_fx_crystal", RenderTypesAS.POSITION_COLOR_TEX_NORMAL, 4, 32768, RenderStateBuilder.builder().texture(TexturesAS.TEX_MODEL_CRYSTAL_WHITE).blend(Blending.DEFAULT).defaultAlpha().disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_BURST = RegistryRenderTypes.createType("effect_fx_burst", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_DYNAMIC_TEXTURE_SPRITE = RegistryRenderTypes.createType("effect_fx_dynamic_texture_sprite", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).alpha(1.0E-4f).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_TEXTURE_SPRITE = RegistryRenderTypes.createType("effect_fx_texture_sprite", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).alpha(1.0E-4f).disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_CUBE_OPAQUE_ATLAS = RegistryRenderTypes.createType("effect_fx_cube_opaque_atlas", DefaultVertexFormats.field_227852_q_, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).defaultAlpha().disableCull().enableLighting().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_BLOCK_TRANSLUCENT = RegistryRenderTypes.createType("effect_fx_block_translucent", DefaultVertexFormats.field_176600_a, RenderStateBuilder.builder().altasTexture().blend(Blending.ADDITIVEDARK).defaultAlpha().disableCull().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_BLOCK_TRANSLUCENT_DEPTH = RegistryRenderTypes.createType("effect_fx_block_translucent_depth", DefaultVertexFormats.field_176600_a, RenderStateBuilder.builder().altasTexture().blend(Blending.ADDITIVEDARK).defaultAlpha().disableCull().disableDepth().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_CUBE_TRANSLUCENT_ATLAS = RegistryRenderTypes.createType("effect_fx_cube_translucent_atlas", DefaultVertexFormats.field_227852_q_, RenderStateBuilder.builder().altasTexture().blend(Blending.ADDITIVEDARK).defaultAlpha().disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_CUBE_TRANSLUCENT_ATLAS_DEPTH = RegistryRenderTypes.createType("effect_fx_cube_translucent_atlas_depth", DefaultVertexFormats.field_227852_q_, RenderStateBuilder.builder().altasTexture().blend(Blending.ADDITIVEDARK).defaultAlpha().disableCull().disableDepthMask().particleShaderTarget().disableDepth().build());
        RenderTypesAS.EFFECT_FX_CUBE_AREA_OF_EFFECT = RegistryRenderTypes.createType("effect_fx_cube_area_of_effect", DefaultVertexFormats.field_227852_q_, RenderStateBuilder.builder().texture(TexturesAS.TEX_AREA_OF_EFFECT_CUBE).blend(Blending.DEFAULT).defaultAlpha().disableCull().disableDepthMask().particleShaderTarget().build());
        RenderTypesAS.EFFECT_FX_COLOR_SPHERE = RegistryRenderTypes.createType("effect_fx_color_sphere", DefaultVertexFormats.field_181706_f, 4, 32768, RenderStateBuilder.builder().blend(Blending.DEFAULT).disableTexture().alpha(1.0E-5f).particleShaderTarget().build());
    }

    private static void initEffects() {
        RenderTypesAS.EFFECT_LIGHTRAY_FAN = RegistryRenderTypes.createType("effect_lightray_fan", DefaultVertexFormats.field_181706_f, 6, 32768, RenderStateBuilder.builder().blend(Blending.ADDITIVE_ALPHA).smoothShade().disableDepthMask().enableDiffuseLighting().build());
        RenderTypesAS.CONSTELLATION_WORLD_STAR = RegistryRenderTypes.createType("effect_render_cst_star", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(TexturesAS.TEX_STAR_1).blend(Blending.DEFAULT).disableDepthMask().build());
        RenderTypesAS.CONSTELLATION_WORLD_CONNECTION = RegistryRenderTypes.createType("effect_render_cst_connection", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(TexturesAS.TEX_STAR_CONNECTION).blend(Blending.DEFAULT).disableDepthMask().build());
    }

    private static void initConstellationTypes() {
        RenderTypesAS.CONSTELLATION_DISCIDIA_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.discidia, TexturesAS.TEX_DISCIDIA_BACKGROUND);
        RenderTypesAS.CONSTELLATION_ARMARA_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.armara, TexturesAS.TEX_ARMARA_BACKGROUND);
        RenderTypesAS.CONSTELLATION_VICIO_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.vicio, TexturesAS.TEX_VICIO_BACKGROUND);
        RenderTypesAS.CONSTELLATION_AEVITAS_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.aevitas, TexturesAS.TEX_AEVITAS_BACKGROUND);
        RenderTypesAS.CONSTELLATION_EVORSIO_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.evorsio, TexturesAS.TEX_EVORSIO_BACKGROUND);
        RenderTypesAS.CONSTELLATION_LUCERNA_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.lucerna, TexturesAS.TEX_LUCERNA_BACKGROUND);
        RenderTypesAS.CONSTELLATION_MINERALIS_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.mineralis, TexturesAS.TEX_MINERALIS_BACKGROUND);
        RenderTypesAS.CONSTELLATION_HOROLOGIUM_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.horologium, TexturesAS.TEX_HOROLOGIUM_BACKGROUND);
        RenderTypesAS.CONSTELLATION_OCTANS_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.octans, TexturesAS.TEX_OCTANS_BACKGROUND);
        RenderTypesAS.CONSTELLATION_BOOTES_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.bootes, TexturesAS.TEX_BOOTES_BACKGROUND);
        RenderTypesAS.CONSTELLATION_FORNAX_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.fornax, TexturesAS.TEX_FORNAX_BACKGROUND);
        RenderTypesAS.CONSTELLATION_PELOTRIO_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.pelotrio, TexturesAS.TEX_PELOTRIO_BACKGROUND);
        RenderTypesAS.CONSTELLATION_GELU_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.gelu, TexturesAS.TEX_GELU_BACKGROUND);
        RenderTypesAS.CONSTELLATION_ULTERIA_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.ulteria, TexturesAS.TEX_ULTERIA_BACKGROUND);
        RenderTypesAS.CONSTELLATION_ALCARA_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.alcara, TexturesAS.TEX_ALCARA_BACKGROUND);
        RenderTypesAS.CONSTELLATION_VORUX_BACKGROUND = RegistryRenderTypes.createConstellationBackgroundType(ConstellationsAS.vorux, TexturesAS.TEX_VORUX_BACKGROUND);
    }

    private static void initGuiTypes() {
        RenderTypesAS.GUI_MISC_INFO_STAR = RegistryRenderTypes.createType("gui_misc_info_star", DefaultVertexFormats.field_181707_g, RenderStateBuilder.builder().texture(TexturesAS.TEX_STAR_1).blend(Blending.DEFAULT).defaultAlpha().build());
    }

    private static void initTERTypes() {
        RenderTypesAS.TER_WELL_LIQUID = RegistryRenderTypes.createType("ter_well_liquid", DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).alpha(1.0E-5f).disableDepthMask().build());
        RenderTypesAS.TER_CHALICE_LIQUID = RegistryRenderTypes.createType("ter_chalice_liquid", RenderTypesAS.POSITION_COLOR_TEX_NORMAL, RenderStateBuilder.builder().altasTexture().blend(Blending.DEFAULT).alpha(1.0E-5f).disableDepthMask().build());
    }

    private static void initModels() {
        RenderTypesAS.MODEL_ATTUNEMENT_ALTAR = RegistryRenderTypes.createType("model_attunement_altar", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "attunement_altar")).enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_LENS_SOLID = RegistryRenderTypes.createType("model_lens", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "lens_frame")).enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_LENS_GLASS = RegistryRenderTypes.createType("model_lens_glass", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "lens_frame")).blend(Blending.DEFAULT).disableDepthMask().enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_LENS_COLORED_SOLID = RegistryRenderTypes.createType("model_lens_colored", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "lens_color")).enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_LENS_COLORED_GLASS = RegistryRenderTypes.createType("model_lens_colored_glass", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "lens_color")).blend(Blending.DEFAULT).disableDepthMask().enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_OBSERVATORY = RegistryRenderTypes.createType("model_observatory", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "observatory")).blend(Blending.DEFAULT).disableCull().enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_REFRACTION_TABLE = RegistryRenderTypes.createType("model_refraction_table", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "refraction_table")).enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_REFRACTION_TABLE_GLASS = RegistryRenderTypes.createType("model_refraction_table_glass", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "refraction_table")).blend(Blending.DEFAULT).disableDepthMask().enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_TELESCOPE = RegistryRenderTypes.createType("model_telescope", DefaultVertexFormats.field_227849_i_, RenderStateBuilder.builder().texture(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "entity", "telescope")).blend(Blending.DEFAULT).disableCull().enableLighting().enableDiffuseLighting().enableOverlay().build());
        RenderTypesAS.MODEL_DEMON_WINGS = RegistryRenderTypes.createType("model_demon_wings", RenderTypesAS.POSITION_COLOR_TEX_NORMAL, RenderStateBuilder.builder().enableLighting().enableDiffuseLighting().smoothShade().build());
        RenderTypesAS.MODEL_CELESTIAL_WINGS = RegistryRenderTypes.createType("model_celestial_wings", RenderTypesAS.POSITION_COLOR_TEX_NORMAL, RenderStateBuilder.builder().texture(TexturesAS.TEX_MODEL_CELESTIAL_WINGS).enableDiffuseLighting().smoothShade().build());
        RenderTypesAS.MODEL_WRAITH_WINGS = RegistryRenderTypes.createType("model_wraith_wings", RenderTypesAS.POSITION_COLOR_TEX_NORMAL, RenderStateBuilder.builder().enableLighting().enableDiffuseLighting().smoothShade().build());
    }

    public static RenderType createDepthProjectionType(int zoom) {
        return RegistryRenderTypes.createType("player_starry_sky_layer", DefaultVertexFormats.field_181706_f, 7, 256, false, true, RenderStateBuilder.builder().blend(Blending.ADDITIVE).texture(AssetLibrary.loadGeneratedResource(AstralSorcery.key("player_starry_sky_layer"), SkyImageGenerator::generateStarBackground, true)).alpha(0.001f).vanillaBuilder().func_228725_a_((RenderState.TexturingState)new IdentityProjectionModelTexturingState(zoom)).func_228728_a_(false));
    }

    private static RenderType createType(String name, VertexFormat vertexFormat, RenderType.State state) {
        return RegistryRenderTypes.createType(name, vertexFormat, 7, 32768, state);
    }

    private static RenderType createType(String name, VertexFormat vertexFormat, int glDrawMode, int bufferSize, RenderType.State state) {
        return RegistryRenderTypes.createType(name, vertexFormat, glDrawMode, bufferSize, false, false, state);
    }

    private static RenderType createType(String name, VertexFormat vertexFormat, int glDrawMode, int bufferSize, boolean usesDelegateDrawing, boolean sortVertices, RenderType.State state) {
        return RenderType.func_228633_a_((String)AstralSorcery.key(name).toString(), (VertexFormat)vertexFormat, (int)glDrawMode, (int)bufferSize, (boolean)usesDelegateDrawing, (boolean)sortVertices, (RenderType.State)state);
    }

    private static RenderType createConstellationBackgroundType(IConstellation cst, AbstractRenderableTexture tex) {
        RenderType rType = RegistryRenderTypes.createType("constellation_background_" + cst.getSimpleName(), DefaultVertexFormats.field_227851_o_, RenderStateBuilder.builder().texture(tex).blend(Blending.DEFAULT).disableDepthMask().build());
        ConstellationRenderInfos.registerBackground(cst, rType, tex);
        return rType;
    }

    private static class IdentityProjectionModelTexturingState
    extends RenderState.TexturingState {
        private final int zoom;

        public IdentityProjectionModelTexturingState(int zoom) {
            super(AstralSorcery.key("depth_projection_texturing_" + zoom).toString(), () -> {
                float movementV = (float)(Util.func_211177_b() % 200000L) / 200000.0f;
                RenderSystem.matrixMode((int)5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
                RenderSystem.scalef((float)0.25f, (float)0.25f, (float)1.0f);
                RenderSystem.translatef((float)(17.0f / (float)zoom), (float)((2.0f + (float)zoom / 1.5f) * movementV), (float)0.0f);
                RenderSystem.rotatef((float)(((float)(zoom * zoom) * 4321.0f + (float)zoom * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.scalef((float)(4.5f - (float)zoom / 4.0f), (float)(4.5f - (float)zoom / 4.0f), (float)1.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.clearTexGen();
            });
            this.zoom = zoom;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IdentityProjectionModelTexturingState that = (IdentityProjectionModelTexturingState)((Object)o);
            return this.zoom == that.zoom;
        }

        public int hashCode() {
            return this.zoom;
        }
    }
}

