/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.source;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.effect.source.FXSource;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;

public abstract class FXSourceOrbital<E extends EntityVisualFX, T extends BatchRenderContext<E>>
extends FXSource<E, T> {
    private double orbitRadius = 1.0;
    private int tickOffset = 0;
    private int branches = 1;
    private Vector3 orbitAxis = Vector3.RotAxis.Y_AXIS;
    private Vector3 offset = new Vector3();

    public FXSourceOrbital(Vector3 pos, T template) {
        super(pos, template);
    }

    public FXSourceOrbital setTicksPerRotation(int ticks) {
        this.maxAge = ticks;
        return this;
    }

    public FXSourceOrbital setBranches(int branches) {
        this.branches = branches;
        return this;
    }

    public FXSourceOrbital setOrbitRadius(double orbitRadius) {
        this.orbitRadius = orbitRadius;
        return this;
    }

    public FXSourceOrbital setOrbitAxis(@Nonnull Vector3 orbitAxis) {
        this.orbitAxis = orbitAxis.clone().normalize();
        return this;
    }

    public FXSourceOrbital setTickOffset(int tickOffset) {
        this.tickOffset = tickOffset;
        return this;
    }

    public FXSourceOrbital setOffset(@Nonnull Vector3 offset) {
        this.offset = offset;
        return this;
    }

    @Nonnull
    public Vector3 getOffset() {
        return this.offset.clone();
    }

    @Nonnull
    public Vector3 getOrbitAxis() {
        return this.orbitAxis.clone();
    }

    @Override
    public void tickSpawnFX(Function<Vector3, E> effectRegistrar) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        for (int branch = 0; branch < this.branches; ++branch) {
            Vector3 point = this.orbitAxis.clone().perpendicular().normalize().multiply(this.orbitRadius).rotate(Math.toRadians(this.getRotationDegree(branch)), this.orbitAxis).add(this.offset).add(this.getPosition());
            this.spawnOrbitalParticle(point, effectRegistrar);
        }
    }

    public abstract void spawnOrbitalParticle(Vector3 var1, Function<Vector3, E> var2);

    private double getRotationDegree(int branch) {
        double perc = (double)((this.age + this.tickOffset) % this.maxAge) / (double)this.maxAge;
        return (double)(360.0f / (float)this.branches * (float)branch) + 360.0 * perc;
    }
}

