/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curioofundying;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="curioofundying")
public class CurioOfUndying {
    public static final String MODID = "curioofundying";

    public CurioOfUndying() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueue);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
    }

    @SubscribeEvent
    public void attachCapabilities(final AttachCapabilitiesEvent<ItemStack> evt) {
        if (((ItemStack)evt.getObject()).func_77973_b() != Items.field_190929_cY) {
            return;
        }
        final ICurio curio = new ICurio(){

            public boolean canRightClickEquip() {
                return true;
            }

            public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
                matrixStack.func_227861_a_(0.0, 0.5, (double)-0.4f);
                matrixStack.func_227863_a_(Direction.DOWN.func_229384_a_());
                Minecraft.func_71410_x().func_175599_af().func_229110_a_((ItemStack)evt.getObject(), ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        evt.addCapability(CuriosCapability.ID_ITEM, provider);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeath(LivingDeathEvent evt) {
        if (this.hasTotemProtection(evt.getEntityLiving(), evt.getSource())) {
            evt.setCanceled(true);
        }
    }

    private boolean hasTotemProtection(LivingEntity livingEntity, DamageSource source) {
        if (source.func_76357_e()) {
            return false;
        }
        for (ItemStack held : livingEntity.func_184214_aD()) {
            if (held.func_77973_b() != Items.field_190929_cY) continue;
            return false;
        }
        return CuriosApi.getCuriosHelper().findEquippedCurio(Items.field_190929_cY, livingEntity).map(totem -> {
            this.activateTotem(livingEntity, (ItemStack)totem.getRight());
            return true;
        }).orElse(false);
    }

    private void activateTotem(LivingEntity livingEntity, ItemStack totem) {
        ItemStack copy = totem.func_77946_l();
        totem.func_190918_g(1);
        if (livingEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)livingEntity;
            serverPlayer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_190929_cY));
            CriteriaTriggers.field_193130_A.func_193187_a(serverPlayer, copy);
        }
        livingEntity.func_70606_j(1.0f);
        livingEntity.func_195061_cb();
        livingEntity.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
        livingEntity.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
        livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)35);
    }
}

