/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.setup.Config;
import insane96mcp.insanelib.utils.MCUtils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Fixes", description="A few fixes")
public class FixFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> fixFollowRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> removeZombiesBonusHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> fixJumpMovementFactorConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> slowdownOnlyConfig;
    public boolean fixFollowRange = true;
    public boolean removeZombiesBonusHealth = true;
    public boolean fixJumpMovementFactor = true;
    public boolean slowdownOnly = true;

    public FixFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.fixFollowRangeConfig = Config.builder.comment("If true, mobs will have their follow range fixed. https://bugs.mojang.com/browse/MC-145656").define("Fix Follow Range", this.fixFollowRange);
        this.removeZombiesBonusHealthConfig = Config.builder.comment("Removes the random bonus health given to Leader Zombies. In vanilla it's useless since doesn't work. https://minecraft.fandom.com/wiki/Attribute#Vanilla_modifiers").define("Remove Zombies Bonus Health", this.removeZombiesBonusHealth);
        this.fixJumpMovementFactorConfig = Config.builder.comment("When affected by slowness the player can still jump really far away. When true, jumps length will be calculated base off player's movement speed.").define("Fix Jump Movement Factor", this.fixJumpMovementFactor);
        this.slowdownOnlyConfig = Config.builder.comment("The fix for Jump Movement Factor is applied only when the player is slowed down.").define("Fix Jump Movement Factor Slowdown Only", this.slowdownOnly);
        Config.builder.pop();
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
        this.fixFollowRange = (Boolean)this.fixFollowRangeConfig.get();
        this.removeZombiesBonusHealth = (Boolean)this.removeZombiesBonusHealthConfig.get();
        this.fixJumpMovementFactor = (Boolean)this.fixJumpMovementFactorConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.fixFollowRange(event.getEntity());
        this.removeZombiesBonusHealth(event.getEntity());
    }

    private void removeZombiesBonusHealth(Entity entity) {
        if (!this.removeZombiesBonusHealth) {
            return;
        }
        if (!(entity instanceof ZombieEntity)) {
            return;
        }
        ZombieEntity zombie = (ZombieEntity)entity;
        if (zombie.func_110148_a(Attributes.field_233818_a_) == null) {
            return;
        }
        Set modifiers = zombie.func_110148_a(Attributes.field_233818_a_).func_225505_c_();
        for (AttributeModifier attributeModifier : modifiers) {
            if (!attributeModifier.func_111166_b().equals("Leader zombie bonus")) continue;
            zombie.func_110148_a(Attributes.field_233818_a_).func_188479_b(attributeModifier.func_111167_a());
        }
    }

    private void fixFollowRange(Entity entity) {
        if (!this.fixFollowRange) {
            return;
        }
        if (!(entity instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)entity;
        ModifiableAttributeInstance followRangeAttribute = mobEntity.func_110148_a(Attributes.field_233819_b_);
        if (followRangeAttribute != null) {
            for (PrioritizedGoal pGoal : mobEntity.field_70715_bh.field_220892_d) {
                if (!(pGoal.func_220772_j() instanceof NearestAttackableTargetGoal)) continue;
                NearestAttackableTargetGoal nearestAttackableTargetGoal = (NearestAttackableTargetGoal)pGoal.func_220772_j();
                nearestAttackableTargetGoal.field_220779_d.func_221013_a(mobEntity.func_233637_b_(Attributes.field_233819_b_));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onUpdate(TickEvent.PlayerTickEvent event) {
        double playerSpeedRatio;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.fixJumpMovementFactor) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        float baseJMF = 0.02f;
        if (event.player.func_70051_ag()) {
            baseJMF += 0.006f;
        }
        if ((playerSpeedRatio = MCUtils.getMovementSpeedRatio(event.player)) > 1.0 && this.slowdownOnly) {
            return;
        }
        event.player.field_70747_aH = (float)(playerSpeedRatio * (double)baseJMF);
    }
}

