/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import vazkii.patchouli.client.book.text.SpanState;

public class Span {
    public final String text;
    public final Style style;
    public final List<Span> linkCluster;
    public final ITextComponent tooltip;
    public final Supplier<Boolean> onClick;
    public final int lineBreaks;
    public final int spacingLeft;
    public final int spacingRight;
    public final boolean bold;

    public static Span error(SpanState state, String message) {
        return new Span(state, message, Style.field_240709_b_.func_240721_b_(TextFormatting.RED));
    }

    public Span(SpanState state, String text) {
        this.text = text;
        this.style = state.peekStyle();
        this.onClick = state.onClick;
        this.linkCluster = state.cluster;
        this.tooltip = state.tooltip;
        this.lineBreaks = state.lineBreaks;
        this.spacingLeft = state.spacingLeft;
        this.spacingRight = state.spacingRight;
        this.bold = this.style.func_150223_b();
        state.lineBreaks = 0;
        state.spacingLeft = 0;
        state.spacingRight = 0;
    }

    private Span(SpanState state, String text, Style style) {
        this.text = text;
        this.style = style;
        this.onClick = null;
        this.linkCluster = null;
        this.tooltip = new StringTextComponent("");
        this.lineBreaks = state.lineBreaks;
        this.spacingLeft = state.spacingLeft;
        this.spacingRight = state.spacingRight;
        this.bold = style.func_150223_b();
        state.lineBreaks = 0;
        state.spacingLeft = 0;
        state.spacingRight = 0;
    }

    public IFormattableTextComponent styledSubstring(int start) {
        return new StringTextComponent(this.text.substring(start)).func_230530_a_(this.style);
    }

    public IFormattableTextComponent styledSubstring(int start, int end) {
        return new StringTextComponent(this.text.substring(start, end)).func_230530_a_(this.style);
    }
}

