/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static boolean areItemsEqual(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a == b || ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsStackable(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a == b || ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b);
    }

    @Nullable
    public static IItemHandler getInventory(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        Entity entity;
        Direction dir;
        Vector3d vecDir;
        BlockState block;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional itemHandler = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (itemHandler.isPresent()) {
                return (IItemHandler)itemHandler.orElseThrow(NullPointerException::new);
            }
            if (tileEntity instanceof ISidedInventory) {
                return new SidedInvWrapper((ISidedInventory)tileEntity, side);
            }
            if (tileEntity instanceof IInventory) {
                return new InvWrapper((IInventory)tileEntity);
            }
        }
        if ((block = world.func_180495_p(pos)).func_177230_c() instanceof ISidedInventoryProvider) {
            ISidedInventory inventory = ((ISidedInventoryProvider)block.func_177230_c()).func_219966_a(block, (IWorld)world, pos);
            return new SidedInvWrapper(inventory, side);
        }
        Vector3d vecStart = new Vector3d((double)pos.func_177958_n() + 0.5 + 0.6 * (double)side.func_82601_c(), (double)pos.func_177956_o() + 0.5 + 0.6 * (double)side.func_96559_d(), (double)pos.func_177952_p() + 0.5 + 0.6 * (double)side.func_82599_e());
        Pair<Entity, Vector3d> hit = WorldUtil.rayTraceEntities(world, vecStart, vecDir = new Vector3d((double)(dir = side.func_176734_d()).func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e()), 1.1);
        if (hit != null && (entity = (Entity)hit.getKey()) instanceof IInventory) {
            return new InvWrapper((IInventory)entity);
        }
        return null;
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory, int begin) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.getSlots(), begin);
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.getSlots(), 0);
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack stack, IItemHandler inventory, int start, int range, int begin) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack remainder = stack.func_77946_l();
        for (int i = 0; i < range; ++i) {
            int slot = start + (i + begin - start) % range;
            if (remainder.func_190926_b()) break;
            remainder = inventory.insertItem(slot, remainder, false);
        }
        return InventoryUtil.areItemsEqual(stack, remainder) ? stack : remainder;
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory, int begin) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.getSlots(), begin);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.getSlots(), 0);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory, int start, int range, int begin) {
        ItemStack partialStack = ItemStack.field_190927_a;
        for (int i = 0; i < range; ++i) {
            ItemStack extracted;
            int slot = start + (i + begin - start) % range;
            if (count <= 0) break;
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b() || !partialStack.func_190926_b() && !InventoryUtil.areItemsStackable(stack, partialStack) || (extracted = inventory.extractItem(slot, count, false)).func_190926_b()) continue;
            if (partialStack.func_190926_b()) {
                partialStack = extracted;
                count = Math.min(count, extracted.func_77976_d());
            } else {
                partialStack.func_190917_f(extracted.func_190916_E());
            }
            count -= extracted.func_190916_E();
        }
        return partialStack;
    }
}

