/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BoatItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.LilyPadItem;
import net.minecraft.item.SignItem;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class TurtlePlaceCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().func_70301_a(turtle.getSelectedSlot());
        if (stack.func_190926_b()) {
            return TurtleCommandResult.failure("No items to place");
        }
        Direction direction = this.direction.toWorldDir(turtle);
        BlockPos coordinates = turtle.getPosition().func_177972_a(direction);
        BlockPos playerPosition = turtle.getPosition().func_177972_a(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        TurtleBlockEvent.Place place = new TurtleBlockEvent.Place(turtle, turtlePlayer, turtle.getWorld(), coordinates, stack);
        if (MinecraftForge.EVENT_BUS.post((Event)place)) {
            return TurtleCommandResult.failure(place.getFailureMessage());
        }
        turtlePlayer.loadInventory(turtle);
        ErrorMessage message = new ErrorMessage();
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, message);
        turtlePlayer.unloadInventory(turtle);
        if (result) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (message.message != null) {
            return TurtleCommandResult.failure(message.message);
        }
        return TurtleCommandResult.failure(stack.func_77973_b() instanceof BlockItem ? "Cannot place block here" : "Cannot place item here");
    }

    public static boolean deployCopiedItem(@Nonnull ItemStack stack, ITurtleAccess turtle, Direction direction, Object[] extraArguments, ErrorMessage outErrorMessage) {
        BlockPos playerPosition = turtle.getPosition().func_177972_a(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(stack);
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, extraArguments, outErrorMessage);
        turtlePlayer.field_71071_by.func_174888_l();
        return result;
    }

    private static boolean deploy(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, Direction direction, Object[] extraArguments, ErrorMessage outErrorMessage) {
        if (TurtlePlaceCommand.deployOnEntity(stack, turtle, turtlePlayer)) {
            return true;
        }
        BlockPos position = turtle.getPosition();
        BlockPos newPosition = position.func_177972_a(direction);
        return TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.func_176734_d(), extraArguments, true, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.func_177972_a(direction), direction.func_176734_d(), extraArguments, false, outErrorMessage) || direction.func_176740_k() != Direction.Axis.Y && TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.func_177977_b(), Direction.UP, extraArguments, false, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
    }

    private static boolean deployOnEntity(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer) {
        Vector3d rayDir;
        World world = turtle.getWorld();
        BlockPos position = turtle.getPosition();
        Vector3d turtlePos = turtlePlayer.func_213303_ch();
        Pair<Entity, Vector3d> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = turtlePlayer.func_70676_i(1.0f), 1.5);
        if (hit == null) {
            return false;
        }
        Entity hitEntity = (Entity)hit.getKey();
        Vector3d hitPos = (Vector3d)hit.getValue();
        InvWrapper itemHandler = new InvWrapper((IInventory)turtlePlayer.field_71071_by);
        DropConsumer.set(hitEntity, arg_0 -> TurtlePlaceCommand.lambda$deployOnEntity$0((IItemHandler)itemHandler, arg_0));
        boolean placed = TurtlePlaceCommand.doDeployOnEntity(stack, turtlePlayer, hitEntity, hitPos);
        DropConsumer.clearAndDrop(world, position, turtle.getDirection().func_176734_d());
        return placed;
    }

    private static boolean doDeployOnEntity(@Nonnull ItemStack stack, TurtlePlayer turtlePlayer, @Nonnull Entity hitEntity, @Nonnull Vector3d hitPos) {
        ActionResultType interactAt = ForgeHooks.onInteractEntityAt((PlayerEntity)turtlePlayer, (Entity)hitEntity, (Vector3d)hitPos, (Hand)Hand.MAIN_HAND);
        if (interactAt == null) {
            interactAt = hitEntity.func_184199_a((PlayerEntity)turtlePlayer, hitPos, Hand.MAIN_HAND);
        }
        if (interactAt.func_226246_a_()) {
            return true;
        }
        ActionResultType interact = ForgeHooks.onInteractEntity((PlayerEntity)turtlePlayer, (Entity)hitEntity, (Hand)Hand.MAIN_HAND);
        if (interact != null) {
            return interact.func_226246_a_();
        }
        if (hitEntity.func_184230_a((PlayerEntity)turtlePlayer, Hand.MAIN_HAND).func_226246_a_()) {
            return true;
        }
        if (hitEntity instanceof LivingEntity) {
            return stack.func_111282_a_((PlayerEntity)turtlePlayer, (LivingEntity)hitEntity, Hand.MAIN_HAND).func_226246_a_();
        }
        return false;
    }

    private static boolean canDeployOnBlock(@Nonnull BlockItemUseContext context, ITurtleAccess turtle, TurtlePlayer player, BlockPos position, Direction side, boolean allowReplaceable, ErrorMessage outErrorMessage) {
        World world = turtle.getWorld();
        if (!World.func_175701_a((BlockPos)position) || world.func_175623_d(position) || context.func_195996_i().func_77973_b() instanceof BlockItem && WorldUtil.isLiquidBlock(world, position)) {
            return false;
        }
        BlockState state = world.func_180495_p(position);
        boolean replaceable = state.func_196953_a(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        if (ComputerCraft.turtlesObeyBlockProtection) {
            boolean editable;
            boolean bl = editable = replaceable ? TurtlePermissions.isBlockEditable(world, position, (PlayerEntity)player) : TurtlePermissions.isBlockEditable(world, position.func_177972_a(side), (PlayerEntity)player);
            if (!editable) {
                if (outErrorMessage != null) {
                    outErrorMessage.message = "Cannot place in protected area";
                }
                return false;
            }
        }
        return true;
    }

    private static boolean deployOnBlock(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, Direction side, Object[] extraArguments, boolean allowReplace, ErrorMessage outErrorMessage) {
        BlockRayTraceResult hit;
        ItemUseContext context;
        Direction playerDir = side.func_176734_d();
        BlockPos playerPosition = position.func_177972_a(side);
        turtlePlayer.setPosition(turtle, playerPosition, playerDir);
        float hitX = 0.5f + (float)side.func_82601_c() * 0.5f;
        float hitY = 0.5f + (float)side.func_96559_d() * 0.5f;
        float hitZ = 0.5f + (float)side.func_82599_e() * 0.5f;
        if (Math.abs(hitY - 0.5f) < 0.01f) {
            hitY = 0.45f;
        }
        if (!TurtlePlaceCommand.canDeployOnBlock(new BlockItemUseContext(context = new ItemUseContext((PlayerEntity)turtlePlayer, Hand.MAIN_HAND, hit = new BlockRayTraceResult(new Vector3d((double)hitX, (double)hitY, (double)hitZ), side, position, false))), turtle, turtlePlayer, position, side, allowReplace, outErrorMessage)) {
            return false;
        }
        Item item = stack.func_77973_b();
        TileEntity existingTile = turtle.getWorld().func_175625_s(position);
        boolean placed = TurtlePlaceCommand.doDeployOnBlock(stack, turtlePlayer, position, context, hit).func_226246_a_();
        if (placed && item instanceof SignItem && extraArguments != null && extraArguments.length >= 1 && extraArguments[0] instanceof String) {
            World world = turtle.getWorld();
            TileEntity tile = world.func_175625_s(position);
            if (tile == null || tile == existingTile) {
                tile = world.func_175625_s(position.func_177972_a(side));
            }
            if (tile instanceof SignTileEntity) {
                TurtlePlaceCommand.setSignText(world, tile, (String)extraArguments[0]);
            }
        }
        return placed;
    }

    private static ActionResultType doDeployOnBlock(@Nonnull ItemStack stack, TurtlePlayer turtlePlayer, BlockPos position, ItemUseContext context, BlockRayTraceResult hit) {
        ActionResultType result;
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)turtlePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)position, (BlockRayTraceResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(context)) != ActionResultType.PASS) {
            return result;
        }
        if (event.getUseItem() != Event.Result.DENY && (result = stack.func_196084_a(context)) != ActionResultType.PASS) {
            return result;
        }
        Item item = stack.func_77973_b();
        if (item instanceof BucketItem || item instanceof BoatItem || item instanceof LilyPadItem || item instanceof GlassBottleItem) {
            ActionResultType actionResult = ForgeHooks.onItemRightClick((PlayerEntity)turtlePlayer, (Hand)Hand.MAIN_HAND);
            if (actionResult != null && actionResult != ActionResultType.PASS) {
                return actionResult;
            }
            ActionResult result2 = stack.func_77957_a(context.func_195991_k(), (PlayerEntity)turtlePlayer, Hand.MAIN_HAND);
            if (result2.func_188397_a().func_226246_a_() && !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)result2.func_188398_b()))) {
                turtlePlayer.func_184611_a(Hand.MAIN_HAND, (ItemStack)result2.func_188398_b());
                return result2.func_188397_a();
            }
        }
        return ActionResultType.PASS;
    }

    private static void setSignText(World world, TileEntity tile, String message) {
        SignTileEntity signTile = (SignTileEntity)tile;
        String[] split = message.split("\n");
        int firstLine = split.length <= 2 ? 1 : 0;
        for (int i = 0; i < 4; ++i) {
            if (i >= firstLine && i < firstLine + split.length) {
                String line = split[i - firstLine];
                signTile.func_212365_a(i, (ITextComponent)(line.length() > 15 ? new StringTextComponent(line.substring(0, 15)) : new StringTextComponent(line)));
                continue;
            }
            signTile.func_212365_a(i, (ITextComponent)new StringTextComponent(""));
        }
        signTile.func_70296_d();
        world.func_184138_a(tile.func_174877_v(), tile.func_195044_w(), tile.func_195044_w(), 3);
    }

    private static /* synthetic */ ItemStack lambda$deployOnEntity$0(IItemHandler itemHandler, ItemStack drop) {
        return InventoryUtil.storeItems(drop, itemHandler, 1);
    }

    private static class ErrorMessage {
        String message;

        private ErrorMessage() {
        }
    }
}

