/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.modem.wired.ItemBlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockCable
extends BlockGeneric
implements IWaterLoggable {
    public static final EnumProperty<CableModemVariant> MODEM = EnumProperty.func_177709_a((String)"modem", CableModemVariant.class);
    public static final BooleanProperty CABLE = BooleanProperty.func_177716_a((String)"cable");
    private static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    private static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    private static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    private static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    private static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    private static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    static final EnumMap<Direction, BooleanProperty> CONNECTIONS = new EnumMap(new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)DOWN).put((Object)Direction.UP, (Object)UP).put((Object)Direction.NORTH, (Object)NORTH).put((Object)Direction.SOUTH, (Object)SOUTH).put((Object)Direction.WEST, (Object)WEST).put((Object)Direction.EAST, (Object)EAST).build());

    public BlockCable(AbstractBlock.Properties settings) {
        super(settings, Registry.ModTiles.CABLE);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(MODEM, (Comparable)((Object)CableModemVariant.None))).func_206870_a((Property)CABLE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MODEM, CABLE, NORTH, SOUTH, EAST, WEST, UP, DOWN, WaterloggableHelpers.WATERLOGGED});
    }

    public static boolean canConnectIn(BlockState state, Direction direction) {
        return (Boolean)state.func_177229_b((Property)CABLE) != false && ((CableModemVariant)((Object)state.func_177229_b(MODEM))).getFacing() != direction;
    }

    public static boolean doesConnectVisually(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        if (!((Boolean)state.func_177229_b((Property)CABLE)).booleanValue()) {
            return false;
        }
        if (((CableModemVariant)((Object)state.func_177229_b(MODEM))).getFacing() == direction) {
            return true;
        }
        return ComputerCraftAPI.getWiredElementAt(world, pos.func_177972_a(direction), direction.func_176734_d()).isPresent();
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return CableShapes.getShape(state);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tile;
        BlockRayTraceResult hit;
        if (((Boolean)state.func_177229_b((Property)CABLE)).booleanValue() && ((CableModemVariant)((Object)state.func_177229_b(MODEM))).getFacing() != null && (hit = world.func_217299_a(new RayTraceContext(WorldUtil.getRayStart((LivingEntity)player), WorldUtil.getRayEnd(player), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player))).func_216346_c() == RayTraceResult.Type.BLOCK && (tile = world.func_175625_s(pos)) instanceof TileCable && tile.func_145830_o()) {
            ItemStack item;
            BlockState newState;
            TileCable cable = (TileCable)tile;
            if (WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) {
                newState = (BlockState)state.func_206870_a(MODEM, (Comparable)((Object)CableModemVariant.None));
                item = new ItemStack((IItemProvider)Registry.ModItems.WIRED_MODEM.get());
            } else {
                newState = (BlockState)state.func_206870_a((Property)CABLE, (Comparable)Boolean.valueOf(false));
                item = new ItemStack((IItemProvider)Registry.ModItems.CABLE.get());
            }
            world.func_180501_a(pos, BlockCable.correctConnections(world, pos, newState), 3);
            cable.modemChanged();
            cable.connectionsChanged();
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
            }
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult hit, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Direction modem = ((CableModemVariant)((Object)state.func_177229_b(MODEM))).getFacing();
        boolean cable = (Boolean)state.func_177229_b((Property)CABLE);
        if (!cable) {
            return new ItemStack((IItemProvider)Registry.ModItems.WIRED_MODEM.get());
        }
        if (modem == null) {
            return new ItemStack((IItemProvider)Registry.ModItems.CABLE.get());
        }
        return hit != null && WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) ? new ItemStack((IItemProvider)Registry.ModItems.WIRED_MODEM.get()) : new ItemStack((IItemProvider)Registry.ModItems.CABLE.get());
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        TileCable cable;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCable && (cable = (TileCable)tile).hasCable()) {
            cable.connectionsChanged();
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    @Nonnull
    @Deprecated
    public FluidState func_204507_t(@Nonnull BlockState state) {
        return WaterloggableHelpers.getWaterloggedFluidState(state);
    }

    @Nonnull
    @Deprecated
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction side, @Nonnull BlockState otherState, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        WaterloggableHelpers.updateWaterloggedPostPlacement(state, world, pos);
        if (!((Boolean)state.func_177229_b((Property)CABLE)).booleanValue() && state.func_177229_b(MODEM) == CableModemVariant.None) {
            return this.func_204507_t(state).func_206883_i();
        }
        return (BlockState)state.func_206870_a((Property)CONNECTIONS.get(side), (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, side)));
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, @Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        Direction facing = ((CableModemVariant)((Object)state.func_177229_b(MODEM))).getFacing();
        if (facing == null) {
            return true;
        }
        return BlockCable.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177972_a(facing), (Direction)facing.func_176734_d());
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getWaterloggedStateForPlacement(context)));
        if (context.func_195996_i().func_77973_b() instanceof ItemBlockCable.Cable) {
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            return BlockCable.correctConnections(world, pos, (BlockState)state.func_206870_a((Property)CABLE, (Comparable)Boolean.valueOf(true)));
        }
        return (BlockState)state.func_206870_a(MODEM, (Comparable)((Object)CableModemVariant.from(context.func_196000_l().func_176734_d())));
    }

    public static BlockState correctConnections(World world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)CABLE)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, Direction.NORTH)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, Direction.EAST)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, Direction.WEST)))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, Direction.UP)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(BlockCable.doesConnectVisually(state, (IBlockReader)world, pos, Direction.DOWN)));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }
}

