/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.network.NetworkMessage;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpeakerAudioClientMessage
implements NetworkMessage {
    private final UUID source;
    private final Vector3d pos;
    private final ByteBuffer content;
    private final float volume;

    public SpeakerAudioClientMessage(UUID source, Vector3d pos, float volume, ByteBuffer content) {
        this.source = source;
        this.pos = pos;
        this.content = content;
        this.volume = volume;
    }

    public SpeakerAudioClientMessage(PacketBuffer buf) {
        this.source = buf.func_179253_g();
        this.pos = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.volume = buf.readFloat();
        SpeakerManager.getSound(this.source).pushAudio((ByteBuf)buf);
        this.content = null;
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        buf.func_179252_a(this.source);
        buf.writeDouble(this.pos.func_82615_a());
        buf.writeDouble(this.pos.func_82617_b());
        buf.writeDouble(this.pos.func_82616_c());
        buf.writeFloat(this.volume);
        buf.writeBytes(this.content.duplicate());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        SpeakerManager.getSound(this.source).playAudio(this.pos, this.volume);
    }
}

