/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.jei;

import dan200.computercraft.api.IUpgradeBase;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

class RecipeResolver
implements IRecipeManagerPlugin {
    static final ComputerFamily[] MAIN_FAMILIES = new ComputerFamily[]{ComputerFamily.NORMAL, ComputerFamily.ADVANCED};
    private final Map<Item, List<UpgradeInfo>> upgradeItemLookup = new HashMap<Item, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    RecipeResolver() {
    }

    private void setupCache() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        TurtleUpgrades.getUpgrades().forEach(upgrade -> {
            ItemStack stack = upgrade.getCraftingItem();
            if (stack.func_190926_b()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, (ITurtleUpgrade)upgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.func_77973_b(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        });
        for (IPocketUpgrade upgrade2 : PocketUpgrades.getUpgrades()) {
            ItemStack stack = upgrade2.getCraftingItem();
            if (stack.func_190926_b()) continue;
            UpgradeInfo info = new UpgradeInfo(stack, upgrade2);
            this.upgradeItemLookup.computeIfAbsent(stack.func_77973_b(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        }
    }

    private boolean hasUpgrade(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.func_77973_b());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.func_190926_b() || craftingStack.func_77973_b() != stack.func_77973_b() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public <V> List<ResourceLocation> getRecipeCategoryUids(@Nonnull IFocus<V> focus) {
        Object value = focus.getValue();
        if (!(value instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ItemStack stack = (ItemStack)value;
        switch (focus.getMode()) {
            case INPUT: {
                return stack.func_77973_b() instanceof ITurtleItem || stack.func_77973_b() instanceof ItemPocketComputer || this.hasUpgrade(stack) ? Collections.singletonList(VanillaRecipeCategoryUid.CRAFTING) : Collections.emptyList();
            }
            case OUTPUT: {
                return stack.func_77973_b() instanceof ITurtleItem || stack.func_77973_b() instanceof ItemPocketComputer ? Collections.singletonList(VanillaRecipeCategoryUid.CRAFTING) : Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T, V> List<T> getRecipes(@Nonnull IRecipeCategory<T> recipeCategory, @Nonnull IFocus<V> focus) {
        if (!(focus.getValue() instanceof ItemStack) || !recipeCategory.getUid().equals((Object)VanillaRecipeCategoryUid.CRAFTING)) {
            return Collections.emptyList();
        }
        ItemStack stack = (ItemStack)focus.getValue();
        switch (focus.getMode()) {
            case INPUT: {
                return RecipeResolver.cast(this.findRecipesWithInput(stack));
            }
            case OUTPUT: {
                return RecipeResolver.cast(RecipeResolver.findRecipesWithOutput(stack));
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T> List<T> getRecipes(@Nonnull IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }

    @Nonnull
    private List<Shaped> findRecipesWithInput(@Nonnull ItemStack stack) {
        this.setupCache();
        if (stack.func_77973_b() instanceof ITurtleItem) {
            ITurtleItem item = (ITurtleItem)stack.func_77973_b();
            ITurtleUpgrade left = item.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return Collections.emptyList();
            }
            ArrayList<Shaped> recipes = new ArrayList<Shaped>();
            Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (left == null) {
                    recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{ingredient, upgrade.ingredient}), RecipeResolver.turtleWith(stack, upgrade.turtle, right)));
                }
                if (right != null) continue;
                recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{upgrade.ingredient, ingredient}), RecipeResolver.turtleWith(stack, left, upgrade.turtle)));
            }
            return RecipeResolver.cast(recipes);
        }
        if (stack.func_77973_b() instanceof ItemPocketComputer) {
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                return Collections.emptyList();
            }
            ArrayList<Shaped> recipes = new ArrayList<Shaped>();
            Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                recipes.add(RecipeResolver.vertical((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{ingredient, upgrade.ingredient}), RecipeResolver.pocketWith(stack, upgrade.pocket)));
            }
            return recipes;
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.func_77973_b());
        if (upgrades == null) {
            return Collections.emptyList();
        }
        List<Shaped> recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.func_190926_b() || craftingStack.func_77973_b() != stack.func_77973_b() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList<Shaped>(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? Collections.emptyList() : recipes;
    }

    @Nonnull
    private static List<Shaped> findRecipesWithOutput(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof ITurtleItem) {
            ITurtleItem item = (ITurtleItem)stack.func_77973_b();
            ArrayList<Shaped> recipes = new ArrayList<Shaped>(0);
            ITurtleUpgrade left = item.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeResolver.turtleWith(stack, null, right)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{left.getCraftingItem()})}), stack));
            }
            if (right != null) {
                recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{right.getCraftingItem()}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeResolver.turtleWith(stack, left, null)})}), stack));
            }
            return RecipeResolver.cast(recipes);
        }
        if (stack.func_77973_b() instanceof ItemPocketComputer) {
            ArrayList<Shaped> recipes = new ArrayList<Shaped>(0);
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                recipes.add(RecipeResolver.vertical((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{back.getCraftingItem()}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeResolver.pocketWith(stack, null)})}), stack));
            }
            return RecipeResolver.cast(recipes);
        }
        return Collections.emptyList();
    }

    private static <T, U> List<T> cast(List<U> from) {
        return from;
    }

    private static ItemStack turtleWith(ItemStack stack, ITurtleUpgrade left, ITurtleUpgrade right) {
        ITurtleItem item = (ITurtleItem)stack.func_77973_b();
        return TurtleItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), left, right, item.getFuelLevel(stack), item.getOverlay(stack));
    }

    private static ItemStack pocketWith(ItemStack stack, IPocketUpgrade back) {
        ItemPocketComputer item = (ItemPocketComputer)stack.func_77973_b();
        return PocketComputerItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), back);
    }

    private static Shaped vertical(NonNullList<Ingredient> input, ItemStack result) {
        return new Shaped(1, input.size(), input, result);
    }

    private static Shaped horizontal(NonNullList<Ingredient> input, ItemStack result) {
        return new Shaped(input.size(), 1, input, result);
    }

    private static class UpgradeInfo {
        final ItemStack stack;
        final Ingredient ingredient;
        final ITurtleUpgrade turtle;
        final IPocketUpgrade pocket;
        final IUpgradeBase upgrade;
        ArrayList<Shaped> recipes;

        UpgradeInfo(ItemStack stack, ITurtleUpgrade turtle) {
            this.stack = stack;
            this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            this.turtle = turtle;
            this.upgrade = this.turtle;
            this.pocket = null;
        }

        UpgradeInfo(ItemStack stack, IPocketUpgrade pocket) {
            this.stack = stack;
            this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            this.turtle = null;
            this.pocket = pocket;
            this.upgrade = this.pocket;
        }

        List<Shaped> getRecipes() {
            ArrayList<Shaped> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            for (ComputerFamily family : MAIN_FAMILIES) {
                if (this.turtle != null && TurtleUpgrades.suitableForFamily(family, this.turtle)) {
                    recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null)})}), TurtleItemFactory.create(-1, null, -1, family, null, this.turtle, 0, null)));
                }
                if (this.pocket == null) continue;
                recipes.add(RecipeResolver.vertical((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PocketComputerItemFactory.create(-1, null, -1, family, null)})}), PocketComputerItemFactory.create(-1, null, -1, family, this.pocket)));
            }
            recipes.trimToSize();
            return recipes;
        }
    }

    private static class Shaped
    extends ShapedRecipe {
        private static final ResourceLocation ID = new ResourceLocation("computercraft", "impostor");

        Shaped(int width, int height, NonNullList<Ingredient> input, ItemStack output) {
            super(ID, null, width, height, input, output);
        }

        @Nonnull
        public IRecipeSerializer<?> func_199559_b() {
            throw new IllegalStateException("Should not serialise the JEI recipe");
        }
    }
}

