/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.apis;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.peripheral.generic.data.BlockData;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.command.Commands;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandAPI
implements ILuaAPI {
    private final TileCommandComputer computer;

    public CommandAPI(TileCommandComputer computer) {
        this.computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"commands"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    private Object[] doCommand(String command) {
        MinecraftServer server = this.computer.func_145831_w().func_73046_m();
        if (server == null || !server.func_82356_Z()) {
            return new Object[]{false, CommandAPI.createOutput("Command blocks disabled by server")};
        }
        Commands commandManager = server.func_195571_aL();
        TileCommandComputer.CommandReceiver receiver = this.computer.getReceiver();
        try {
            receiver.clearOutput();
            int result = commandManager.func_197059_a(this.computer.getSource(), command);
            return new Object[]{result > 0, receiver.copyOutput(), result};
        }
        catch (Throwable t) {
            if (ComputerCraft.logComputerErrors) {
                ComputerCraft.log.error("Error running command.", t);
            }
            return new Object[]{false, CommandAPI.createOutput("Java Exception Thrown: " + t)};
        }
    }

    private static Map<?, ?> getBlockInfo(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        HashMap<String, Object> table = BlockData.fill(new HashMap(), state);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            table.put("nbt", NBTUtil.toLua((INBT)tile.func_189515_b(new CompoundNBT())));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public final Object[] exec(String command) {
        return this.doCommand(command);
    }

    @LuaFunction
    public final long execAsync(ILuaContext context, String command) throws LuaException {
        return context.issueMainThreadTask(() -> this.doCommand(command));
    }

    @LuaFunction(mainThread=true)
    public final List<String> list(IArguments args) throws LuaException {
        MinecraftServer server = this.computer.func_145831_w().func_73046_m();
        if (server == null) {
            return Collections.emptyList();
        }
        RootCommandNode node = server.func_195571_aL().func_197054_a().getRoot();
        for (int j = 0; j < args.count(); ++j) {
            String name = args.getString(j);
            if ((node = node.getChild(name)) instanceof LiteralCommandNode) continue;
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (CommandNode child : node.getChildren()) {
            if (!(child instanceof LiteralCommandNode)) continue;
            result.add(child.getName());
        }
        return result;
    }

    @LuaFunction
    public final Object[] getBlockPosition() {
        BlockPos pos = this.computer.func_174877_v();
        return new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    @LuaFunction(mainThread=true)
    public final List<Map<?, ?>> getBlockInfos(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Optional<String> dimension) throws LuaException {
        World world = this.getLevel(dimension);
        BlockPos min = new BlockPos(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        BlockPos max = new BlockPos(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
        if (!World.func_175701_a((BlockPos)min) || !World.func_175701_a((BlockPos)max)) {
            throw new LuaException("Co-ordinates out of range");
        }
        int blocks = (max.func_177958_n() - min.func_177958_n() + 1) * (max.func_177956_o() - min.func_177956_o() + 1) * (max.func_177952_p() - min.func_177952_p() + 1);
        if (blocks > 4096) {
            throw new LuaException("Too many blocks");
        }
        ArrayList results = new ArrayList(blocks);
        for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
            for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    results.add(CommandAPI.getBlockInfo(world, pos));
                }
            }
        }
        return results;
    }

    @LuaFunction(mainThread=true)
    public final Map<?, ?> getBlockInfo(int x, int y, int z, Optional<String> dimension) throws LuaException {
        World world = this.getLevel(dimension);
        BlockPos position = new BlockPos(x, y, z);
        if (!World.func_175701_a((BlockPos)position)) {
            throw new LuaException("Co-ordinates out of range");
        }
        return CommandAPI.getBlockInfo(world, position);
    }

    @Nonnull
    private World getLevel(@Nonnull Optional<String> id) throws LuaException {
        World currentWorld = this.computer.func_145831_w();
        if (currentWorld == null) {
            throw new LuaException("No world exists");
        }
        if (!id.isPresent()) {
            return currentWorld;
        }
        ResourceLocation dimensionId = ResourceLocation.func_208304_a((String)id.get());
        if (dimensionId == null) {
            throw new LuaException("Invalid dimension name");
        }
        ServerWorld world = currentWorld.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimensionId));
        if (world == null) {
            throw new LuaException("Unknown dimension");
        }
        return world;
    }
}

