/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;

public final class PocketUpgrades {
    private static final Map<String, IPocketUpgrade> upgrades = new HashMap<String, IPocketUpgrade>();
    private static final Map<IPocketUpgrade, String> upgradeOwners = new Object2ObjectLinkedOpenCustomHashMap(Util.func_212443_g());

    private PocketUpgrades() {
    }

    public static synchronized void register(@Nonnull IPocketUpgrade upgrade) {
        Objects.requireNonNull(upgrade, "upgrade cannot be null");
        String id = upgrade.getUpgradeID().toString();
        IPocketUpgrade existing = upgrades.get(id);
        if (existing != null) {
            throw new IllegalStateException("Error registering '" + upgrade.getUnlocalisedAdjective() + " pocket computer'. UpgradeID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " pocket computer'");
        }
        upgrades.put(id, upgrade);
        ModContainer mc = ModLoadingContext.get().getActiveContainer();
        if (mc != null && mc.getModId() != null) {
            upgradeOwners.put(upgrade, mc.getModId());
        }
    }

    public static IPocketUpgrade get(String id) {
        if (id.equals("computercraft:advanved_modem")) {
            id = "computercraft:advanced_modem";
        }
        return upgrades.get(id);
    }

    public static IPocketUpgrade get(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IPocketUpgrade upgrade : upgrades.values()) {
            ItemStack craftingStack = upgrade.getCraftingItem();
            if (craftingStack.func_190926_b() || craftingStack.func_77973_b() != stack.func_77973_b() || !upgrade.isItemSuitable(stack)) continue;
            return upgrade;
        }
        return null;
    }

    @Nullable
    public static String getOwner(IPocketUpgrade upgrade) {
        return upgradeOwners.get(upgrade);
    }

    public static Iterable<IPocketUpgrade> getVanillaUpgrades() {
        ArrayList<IPocketUpgrade> vanilla = new ArrayList<IPocketUpgrade>();
        vanilla.add(ComputerCraft.PocketUpgrades.wirelessModemNormal);
        vanilla.add(ComputerCraft.PocketUpgrades.wirelessModemAdvanced);
        vanilla.add(ComputerCraft.PocketUpgrades.speaker);
        return vanilla;
    }

    public static Iterable<IPocketUpgrade> getUpgrades() {
        return Collections.unmodifiableCollection(upgrades.values());
    }
}

