/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class ItemPocketRenderer
extends ItemMapLikeRenderer {
    private static final ItemPocketRenderer INSTANCE = new ItemPocketRenderer();

    private ItemPocketRenderer() {
    }

    @SubscribeEvent
    public static void onRenderInHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.func_77973_b() instanceof ItemPocketComputer)) {
            return;
        }
        event.setCanceled(true);
        INSTANCE.renderItemFirstPerson(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getHand(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), event.getItemStack());
    }

    @Override
    protected void renderItem(MatrixStack transform, IRenderTypeBuffer render, ItemStack stack) {
        int termHeight;
        int termWidth;
        Terminal terminal;
        ClientComputer computer = ItemPocketComputer.createClientComputer(stack);
        Terminal terminal2 = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = ComputerCraft.pocketTermWidth;
            termHeight = ComputerCraft.pocketTermHeight;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.func_227860_a_();
        transform.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        transform.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        transform.func_227862_a_(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.func_227862_a_(scale, scale, 0.0f);
        transform.func_227861_a_(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        ItemPocketComputer item = (ItemPocketComputer)stack.func_77973_b();
        ComputerFamily family = item.getFamily();
        int frameColour = item.getColour(stack);
        Matrix4f matrix = transform.func_227866_c_().func_227870_a_();
        ItemPocketRenderer.renderFrame(matrix, family, frameColour, width, height);
        int lightColour = ItemPocketComputer.getLightState(stack);
        if (lightColour == -1) {
            lightColour = Colour.BLACK.getHex();
        }
        ItemPocketRenderer.renderLight(matrix, lightColour, width, height);
        if (computer != null && terminal != null) {
            FixedWidthFontRenderer.drawTerminal(matrix, 2.0f, 2.0f, terminal, !computer.isColour(), 2.0f, 2.0f, 2.0f, 2.0f);
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(matrix, 0.0f, 0.0f, width, height);
        }
        transform.func_227865_b_();
    }

    private static void renderFrame(Matrix4f transform, ComputerFamily family, int colour, int width, int height) {
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(colour != -1 ? ComputerBorderRenderer.BACKGROUND_COLOUR : ComputerBorderRenderer.getTexture(family));
        float r = (float)(colour >>> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >>> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        ComputerBorderRenderer.render(transform, (IVertexBuilder)buffer, 0, 0, 0, width, height, true, r, g, b);
        tessellator.func_78381_a();
    }

    private static void renderLight(Matrix4f transform, int colour, int width, int height) {
        RenderSystem.disableTexture();
        float r = (float)(colour >>> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >>> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(transform, (float)(width - 16), (float)(height + 8) + 6.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        buffer.func_227888_a_(transform, (float)width, (float)(height + 8) + 6.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        buffer.func_227888_a_(transform, (float)width, (float)height + 6.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        buffer.func_227888_a_(transform, (float)(width - 16), (float)height + 6.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
    }
}

