/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IBidiRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public final class OptionScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("computercraft", "textures/gui/blank_screen.png");
    public static final int BUTTON_WIDTH = 100;
    public static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 16;
    private static final int FONT_HEIGHT = 9;
    private int x;
    private int y;
    private int innerWidth;
    private int innerHeight;
    private IBidiRenderer messageRenderer;
    private final ITextComponent message;
    private final List<Widget> buttons;
    private final Runnable exit;
    private final Screen originalScreen;

    private OptionScreen(ITextComponent title, ITextComponent message, List<Widget> buttons, Runnable exit, Screen originalScreen) {
        super(title);
        this.message = message;
        this.buttons = buttons;
        this.exit = exit;
        this.originalScreen = originalScreen;
    }

    public static void show(Minecraft minecraft, ITextComponent title, ITextComponent message, List<Widget> buttons, Runnable exit) {
        minecraft.func_147108_a((Screen)new OptionScreen(title, message, buttons, exit, OptionScreen.unwrap(minecraft.field_71462_r)));
    }

    public static Screen unwrap(Screen screen) {
        return screen instanceof OptionScreen ? ((OptionScreen)screen).getOriginalScreen() : screen;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int buttonWidth = 100 * this.buttons.size() + 16 * (this.buttons.size() - 1);
        int innerWidth = this.innerWidth = Math.max(256, buttonWidth + 32);
        this.messageRenderer = IBidiRenderer.func_243258_a((FontRenderer)this.field_230712_o_, (ITextProperties)this.message, (int)(innerWidth - 32));
        int textHeight = this.messageRenderer.func_241862_a() * 9 + 32;
        this.innerHeight = textHeight + (this.buttons.isEmpty() ? 0 : this.buttons.get(0).func_238483_d_()) + 16;
        this.x = (this.field_230708_k_ - innerWidth) / 2;
        this.y = (this.field_230709_l_ - this.innerHeight) / 2;
        int x = (this.field_230708_k_ - buttonWidth) / 2;
        for (Widget button : this.buttons) {
            button.field_230690_l_ = x;
            button.field_230691_m_ = this.y + textHeight;
            this.func_230480_a_(button);
            x += 116;
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(transform);
        this.field_230706_i_.field_71446_o.func_110577_a(BACKGROUND);
        this.func_238474_b_(transform, this.x, this.y, 0, 0, this.innerWidth, 16);
        OptionScreen.func_238463_a_((MatrixStack)transform, (int)this.x, (int)(this.y + 16), (float)0.0f, (float)16.0f, (int)this.innerWidth, (int)(this.innerHeight - 32), (int)this.innerWidth, (int)16);
        this.func_238474_b_(transform, this.x, this.y + this.innerHeight - 16, 0, 240, this.innerWidth, 16);
        this.messageRenderer.func_241866_c(transform, this.x + 16, this.y + 16, 9, 0x404040);
        super.func_230430_a_(transform, mouseX, mouseY, partialTicks);
    }

    public void func_231175_as__() {
        this.exit.run();
    }

    public static Widget newButton(ITextComponent component, Button.IPressable clicked) {
        return new Button(0, 0, 100, 20, component, clicked);
    }

    public void disable() {
        for (Widget widget : this.buttons) {
            widget.field_230693_o_ = false;
        }
    }

    @Nonnull
    public Screen getOriginalScreen() {
        return this.originalScreen;
    }
}

