/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tileentity;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.block.BookcaseBlock;
import svenhjol.charm.container.BookcaseContainer;
import svenhjol.charm.module.Bookcases;
import vazkii.quark.api.ITransferManager;

public class BookcaseTileEntity
extends LockableLootTileEntity
implements ISidedInventory,
ITransferManager {
    public static int SIZE = 18;
    private static final int[] SLOTS = IntStream.range(0, SIZE).toArray();
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)SIZE, (Object)ItemStack.field_190927_a);

    public BookcaseTileEntity() {
        super(Bookcases.TILE_ENTITY);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.items = NonNullList.func_191197_a((int)SIZE, (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(tag)) {
            ItemStackHelper.func_191283_b((CompoundNBT)tag, this.items);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.func_184282_c(tag)) {
            ItemStackHelper.func_191282_a((CompoundNBT)tag, this.items);
        }
        return tag;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> list) {
        this.items = list;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TranslationTextComponent("container.charm.bookcase");
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.charm.bookcase");
    }

    protected Container func_213906_a(int syncId, PlayerInventory playerInventory) {
        return new BookcaseContainer(syncId, playerInventory, (IInventory)this);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.updateBlockState();
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction dir) {
        return Bookcases.canContainItem(stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public int func_70302_i_() {
        return SIZE;
    }

    public void func_174889_b(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, this.field_174879_c, CharmSounds.BOOKSHELF_OPEN, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_174886_c(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, this.field_174879_c, CharmSounds.BOOKSHELF_CLOSE, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_70296_d() {
        this.updateBlockState();
        super.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected void updateBlockState() {
        int filled = 0;
        for (int i = 0; i < SIZE; ++i) {
            ItemStack stack;
            if (this.field_145850_b == null || (stack = this.func_70301_a(i)).func_190926_b()) continue;
            ++filled;
        }
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BookcaseBlock) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BookcaseBlock.SLOTS, (Comparable)Integer.valueOf(filled)), 2);
        }
    }

    @Override
    public boolean acceptsTransfer(PlayerEntity playerEntity) {
        return true;
    }
}

