/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.BiomeHelper;
import svenhjol.charm.base.helper.MapHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Wandering traders only appear near signal campfires and sell maps to biomes and structures.", hasSubscriptions=true)
public class WanderingTraderImprovements
extends CharmModule {
    public static final List<TraderMap> traderMaps = new ArrayList<TraderMap>();
    @Config(name="Trade biome maps", description="If true, wandering traders will sell maps to biomes.")
    public static boolean tradeBiomeMaps = true;
    @Config(name="Trade structure maps", description="If true, wandering traders will sell maps to structures.")
    public static boolean tradeStructureMaps = true;
    @Config(name="Frequent spawning", description="If true, makes wandering traders more likely to spawn after one Minecraft day.")
    public static boolean frequentSpawn = false;

    @Override
    public void init() {
        if (tradeStructureMaps) {
            traderMaps.addAll(Arrays.asList(new StructureMap(Structure.field_236372_h_, false), new StructureMap(Structure.field_236381_q_, false), new StructureMap((Structure<?>)Structure.field_236374_j_, false), new StructureMap(Structure.field_236373_i_, false), new StructureMap(Structure.field_236377_m_, false), new StructureMap(Structure.field_236366_b_, false), new StructureMap(Structure.field_236367_c_, false), new StructureMap(Structure.field_236371_g_, false), new StructureMap(Structure.field_236369_e_, true), new StructureMap(Structure.field_236370_f_, true)));
        }
        if (tradeBiomeMaps) {
            traderMaps.addAll(Arrays.asList(new BiomeMap((RegistryKey<Biome>)Biomes.field_203614_T, false), new BiomeMap((RegistryKey<Biome>)Biomes.field_76774_n, false), new BiomeMap((RegistryKey<Biome>)Biomes.field_76769_d, false), new BiomeMap((RegistryKey<Biome>)Biomes.field_185441_Q, false), new BiomeMap((RegistryKey<Biome>)Biomes.field_76776_l, false), new BiomeMap((RegistryKey<Biome>)Biomes.field_150589_Z, true), new BiomeMap((RegistryKey<Biome>)Biomes.field_185444_T, true), new BiomeMap((RegistryKey<Biome>)Biomes.field_76789_p, true), new BiomeMap((RegistryKey<Biome>)Biomes.field_222370_aw, true), new BiomeMap((RegistryKey<Biome>)Biomes.field_185445_W, true)));
        }
    }

    @SubscribeEvent
    public void onWandererTrades(WandererTradesEvent event) {
        for (int i = 0; i < 3; ++i) {
            event.getGenericTrades().add(new StructureMapForEmeraldsTrade());
            event.getRareTrades().add(new StructureMapForEmeraldsTrade());
        }
    }

    public static boolean shouldSpawnFrequently() {
        return ModuleHandler.enabled(WanderingTraderImprovements.class) && frequentSpawn;
    }

    public static class BiomeMap
    implements TraderMap {
        public RegistryKey<Biome> biomeKey;
        public boolean rare;

        public BiomeMap(RegistryKey<Biome> biomeKey, boolean rare) {
            this.biomeKey = biomeKey;
            this.rare = rare;
        }

        @Override
        public ItemStack getMap(ServerWorld world, BlockPos pos) {
            int color = 8806;
            BlockPos nearestBiome = BiomeHelper.locateBiome(this.biomeKey, world, pos);
            String biomeName = this.biomeKey.func_240901_a_().func_110623_a();
            if (nearestBiome == null) {
                return null;
            }
            TranslationTextComponent mapName = new TranslationTextComponent("filled_map.charm.trader_map", new Object[]{new TranslationTextComponent("biome.minecraft." + biomeName)});
            return MapHelper.getMap(world, nearestBiome, mapName, MapDecoration.Type.TARGET_X, color);
        }

        @Override
        public int getCost(Random rand) {
            return this.rare ? rand.nextInt(3) + 3 : rand.nextInt(1) + 1;
        }
    }

    public static class StructureMap
    implements TraderMap {
        public Structure<?> structure;
        public boolean rare;

        public StructureMap(Structure<?> structure, boolean rare) {
            this.structure = structure;
            this.rare = rare;
        }

        @Override
        public ItemStack getMap(ServerWorld world, BlockPos pos) {
            int color = 0x662200;
            BlockPos nearestStructure = world.func_241117_a_(this.structure, pos, 2000, true);
            if (nearestStructure == null) {
                return null;
            }
            TranslationTextComponent structureName = new TranslationTextComponent("structure.charm." + this.structure.func_143025_a());
            TranslationTextComponent mapName = new TranslationTextComponent("filled_map.charm.trader_map", new Object[]{structureName});
            return MapHelper.getMap(world, nearestStructure, mapName, MapDecoration.Type.TARGET_X, color);
        }

        @Override
        public int getCost(Random rand) {
            return this.rare ? rand.nextInt(4) + 6 : rand.nextInt(2) + 2;
        }
    }

    public static interface TraderMap {
        public ItemStack getMap(ServerWorld var1, BlockPos var2);

        public int getCost(Random var1);
    }

    public static class StructureMapForEmeraldsTrade
    implements VillagerTrades.ITrade {
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            TraderMap traderMap;
            ItemStack map;
            if (!trader.field_70170_p.field_72995_K && !traderMaps.isEmpty() && (map = (traderMap = traderMaps.get(rand.nextInt(traderMaps.size()))).getMap((ServerWorld)trader.field_70170_p, trader.func_233580_cy_())) != null) {
                ItemStack in1 = new ItemStack((IItemProvider)Items.field_151166_bC, traderMap.getCost(rand));
                ItemStack in2 = new ItemStack((IItemProvider)Items.field_151111_aL);
                return new MerchantOffer(in1, in2, map, 1, 5, 0.2f);
            }
            return null;
        }
    }
}

