/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.BiomeHelper;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", hasSubscriptions=true, description="Villages can spawn in swamps and jungles.")
public class MoreVillageBiomes
extends CharmModule {
    private List<ResourceLocation> plainsBiomes = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> taigaBiomes = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> snowyBiomes = new ArrayList<ResourceLocation>();

    @Override
    public void init() {
        this.plainsBiomes = new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft:jungle"), new ResourceLocation("minecraft:bamboo_jungle"), new ResourceLocation("minecraft:swamp")));
        this.taigaBiomes = new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft:snowy_taiga")));
        this.snowyBiomes = new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft:ice_spikes")));
    }

    @SubscribeEvent
    public void onVillagerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.isCanceled()) {
            this.changeVillagerSkin(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent event) {
        if (!event.isCanceled()) {
            this.tryAddStructureToBiome(event);
        }
    }

    private void changeVillagerSkin(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof VillagerEntity && entity.field_70175_ag && entity.field_70173_aa == 0) {
            Biome biome;
            Biome.Category category;
            VillagerEntity villager = (VillagerEntity)entity;
            VillagerData data = villager.func_213700_eh();
            ServerWorld world = (ServerWorld)entity.field_70170_p;
            if (data.func_221129_a() == VillagerType.field_221175_c && ((category = (biome = BiomeHelper.getBiome(world, villager.func_233580_cy_())).func_201856_r()).equals((Object)Biome.Category.JUNGLE) || category.equals((Object)Biome.Category.SWAMP))) {
                villager.func_213753_a(data.func_221134_a(VillagerType.func_242371_a(BiomeHelper.getBiomeKeyAtPosition(world, villager.func_233580_cy_()))));
            }
        }
    }

    private void tryAddStructureToBiome(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        List structures = event.getGeneration().getStructures();
        ResourceLocation biomeId = event.getName();
        if (this.plainsBiomes.contains(biomeId)) {
            structures.add(() -> StructureFeatures.field_244154_t);
        } else if (this.taigaBiomes.contains(biomeId)) {
            structures.add(() -> StructureFeatures.field_244158_x);
        } else if (this.snowyBiomes.contains(biomeId)) {
            structures.add(() -> StructureFeatures.field_244157_w);
        }
    }
}

