/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.mixin.accessor.MineshaftPiecesAccessor;
import svenhjol.charm.mixin.accessor.StructurePieceAccessor;
import svenhjol.charm.module.Crates;
import svenhjol.charm.tileentity.CrateTileEntity;

@Module(mod="charm", description="Adds decoration and more ores to mineshafts.")
public class MineshaftImprovements
extends CharmModule {
    public static List<BlockState> commonFloorBlocks = new ArrayList<BlockState>();
    public static List<BlockState> commonCeilingBlocks = new ArrayList<BlockState>();
    public static List<BlockState> rareFloorBlocks = new ArrayList<BlockState>();
    public static List<BlockState> rareCeilingBlocks = new ArrayList<BlockState>();
    public static List<BlockState> pileBlocks = new ArrayList<BlockState>();
    public static List<BlockState> roomBlocks = new ArrayList<BlockState>();
    public static List<BlockState> roomDecoration = new ArrayList<BlockState>();
    public static List<ResourceLocation> crateLootTables = new ArrayList<ResourceLocation>();
    public static float floorBlockChance = 0.05f;
    public static float ceilingBlockChance = 0.03f;
    public static float rareBlockChance = 0.08f;
    public static float roomBlockChance = 0.32f;
    public static float blockPileChance = 0.12f;
    public static float crateChance = 0.14f;
    @Config(name="Corridor blocks", description="If true, stone, ore, lanterns and TNT will spawn inside mineshaft corridors.")
    public static boolean generateCorridorBlocks = true;
    @Config(name="Corridor block piles", description="If true, occasionally there will be piles of ore in mineshaft corridors.")
    public static boolean generateCorridorPiles = true;
    @Config(name="Room blocks", description="If true, precious ores will spawn in the central mineshaft room.")
    public static boolean generateRoomBlocks = true;
    @Config(name="Add crates", description="If true, loot crates will be added to mineshaft corridors.")
    public static boolean generateCrates = true;

    @Override
    public void init() {
        commonFloorBlocks.addAll(Arrays.asList(Blocks.field_150366_p.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150352_o.func_176223_P()));
        rareFloorBlocks.addAll(Arrays.asList(Blocks.field_150335_W.func_176223_P(), Blocks.field_222432_lU.func_176223_P()));
        pileBlocks.addAll(Arrays.asList(Blocks.field_150366_p.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150450_ax.func_176223_P(), Blocks.field_150352_o.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150351_n.func_176223_P()));
        commonCeilingBlocks.addAll(Arrays.asList(Blocks.field_196553_aF.func_176223_P(), (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150366_p.func_176223_P(), Blocks.field_150365_q.func_176223_P()));
        rareCeilingBlocks.addAll(Arrays.asList(Blocks.field_150352_o.func_176223_P()));
        roomBlocks.addAll(Arrays.asList(Blocks.field_150482_ag.func_176223_P(), Blocks.field_150352_o.func_176223_P(), Blocks.field_150369_x.func_176223_P()));
        roomDecoration.addAll(Arrays.asList(Blocks.field_150341_Y.func_176223_P(), Blocks.field_222450_ln.func_176223_P(), Blocks.field_150346_d.func_176223_P()));
        crateLootTables.addAll(Arrays.asList(LootTables.field_186424_f, LootTables.field_186422_d, LootTables.field_215817_h, LootTables.field_215818_i, LootTables.field_215815_f, LootTables.field_215814_e));
    }

    public static void generatePiece(StructurePiece piece, ISeedReader world, StructureManager accessor, ChunkGenerator chunkGenerator, Random rand, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        if (!ModuleHandler.enabled(MineshaftImprovements.class)) {
            return;
        }
        if (((MineshaftPiecesAccessor)piece).getMineShaftType() == MineshaftStructure.Type.MESA) {
            return;
        }
        if (piece instanceof MineshaftPieces.Corridor) {
            MineshaftImprovements.corridor((MineshaftPieces.Corridor)piece, world, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        } else if (piece instanceof MineshaftPieces.Room) {
            MineshaftImprovements.room((MineshaftPieces.Room)piece, world, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        }
    }

    private static void corridor(MineshaftPieces.Corridor piece, ISeedReader world, StructureManager accessor, ChunkGenerator chunkGenerator, Random rand, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        int z;
        int bx = box.field_78893_d - box.field_78897_a;
        int bz = box.field_78892_f - box.field_78896_c;
        if (generateCorridorBlocks) {
            if (bx <= 0) {
                bx = 3;
            }
            if (bz <= 0) {
                bz = 7;
            }
            for (int x = 0; x < bx; ++x) {
                if (x == 1 && rand.nextFloat() < 0.08f) continue;
                for (int z2 = 0; z2 < bz; ++z2) {
                    if (MineshaftImprovements.validFloorBlock((StructurePiece)piece, world, x, 0, z2, box) && rand.nextFloat() < floorBlockChance) {
                        ((StructurePieceAccessor)piece).invokeSetBlockState(world, MineshaftImprovements.getFloorBlock(rand), x, 0, z2, box);
                    }
                    if (!MineshaftImprovements.validCeilingBlock((StructurePiece)piece, world, x, 2, z2, box) || !(rand.nextFloat() < ceilingBlockChance)) continue;
                    ((StructurePieceAccessor)piece).invokeSetBlockState(world, MineshaftImprovements.getCeilingBlock(rand), x, 2, z2, box);
                }
            }
        }
        if (generateCorridorPiles && rand.nextFloat() < blockPileChance && MineshaftImprovements.validFloorBlock((StructurePiece)piece, world, 1, 0, z = rand.nextInt(bz), box)) {
            BlockState block1 = MineshaftImprovements.getRandomBlockFromList(pileBlocks, rand);
            BlockState block2 = MineshaftImprovements.getRandomBlockFromList(pileBlocks, rand);
            for (int iy = 0; iy < 3; ++iy) {
                for (int ix = 0; ix <= 2; ++ix) {
                    for (int iz = -1; iz <= 1; ++iz) {
                        boolean valid = MineshaftImprovements.validFloorBlock((StructurePiece)piece, world, ix, iy, iz, box);
                        if (!valid || !(rand.nextFloat() < 0.75f)) continue;
                        ((StructurePieceAccessor)piece).invokeSetBlockState(world, (double)rand.nextFloat() < 0.5 ? block1 : block2, ix, iy, iz, box);
                    }
                }
            }
        }
        if (generateCrates && ModuleHandler.enabled(Crates.class) && rand.nextFloat() < crateChance && rand.nextFloat() < 0.9f) {
            int z3;
            int r = rand.nextInt(3) + 12;
            int y = ((StructurePieceAccessor)piece).invokeGetYWithOffset(0);
            int x = ((StructurePieceAccessor)piece).invokeGetXWithOffset(1, r);
            BlockPos blockpos = new BlockPos(x, y, z3 = ((StructurePieceAccessor)piece).invokeGetZWithOffset(1, r));
            if (box.func_175898_b((Vector3i)blockpos)) {
                BlockState state = Crates.getRandomCrateBlock(rand).func_176223_P();
                ResourceLocation loot = crateLootTables.get(rand.nextInt(crateLootTables.size()));
                world.func_180501_a(blockpos, state, 2);
                TileEntity tileEntity = world.func_175625_s(blockpos);
                if (tileEntity instanceof CrateTileEntity) {
                    ((CrateTileEntity)tileEntity).func_189404_a(loot, rand.nextLong());
                    tileEntity.func_189515_b(new CompoundNBT());
                }
            }
        }
    }

    private static void room(MineshaftPieces.Room piece, ISeedReader world, StructureManager accessor, ChunkGenerator chunkGenerator, Random rand, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        if (generateRoomBlocks) {
            int bx = box.field_78893_d - box.field_78897_a;
            int bz = box.field_78892_f - box.field_78896_c;
            if (bx <= 0) {
                bx = 15;
            }
            if (bz <= 0) {
                bz = 15;
            }
            for (int y = 1; y <= 2; ++y) {
                for (int x = 0; x <= bx; ++x) {
                    for (int z = 0; z <= bz; ++z) {
                        BlockState state;
                        if (!(rand.nextFloat() < roomBlockChance)) continue;
                        if (y == 1) {
                            state = rand.nextFloat() < 0.5f ? MineshaftImprovements.getRandomBlockFromList(roomBlocks, rand) : MineshaftImprovements.getRandomBlockFromList(roomDecoration, rand);
                        } else {
                            if (rand.nextFloat() < 0.5f) continue;
                            state = MineshaftImprovements.getRandomBlockFromList(roomBlocks, rand);
                        }
                        BlockPos pos = new BlockPos(((StructurePieceAccessor)piece).getBoundingBox().field_78897_a + x, ((StructurePieceAccessor)piece).getBoundingBox().field_78895_b + y, ((StructurePieceAccessor)piece).getBoundingBox().field_78896_c + z);
                        if (!world.func_175623_d(pos) || !world.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)world, pos.func_177977_b()) || world.func_175710_j(pos)) continue;
                        world.func_180501_a(pos, state, 11);
                    }
                }
            }
        }
    }

    private static boolean validCeilingBlock(StructurePiece piece, ISeedReader world, int x, int y, int z, MutableBoundingBox box) {
        BlockPos blockpos = new BlockPos(((StructurePieceAccessor)piece).invokeGetXWithOffset(x, z), ((StructurePieceAccessor)piece).invokeGetYWithOffset(y), ((StructurePieceAccessor)piece).invokeGetZWithOffset(x, z));
        return box.func_175898_b((Vector3i)blockpos) && world.func_180495_p(blockpos.func_177984_a()).func_200132_m() && world.func_175623_d(blockpos.func_177977_b());
    }

    private static boolean validFloorBlock(StructurePiece piece, ISeedReader world, int x, int y, int z, MutableBoundingBox box) {
        BlockPos blockpos = new BlockPos(((StructurePieceAccessor)piece).invokeGetXWithOffset(x, z), ((StructurePieceAccessor)piece).invokeGetYWithOffset(y), ((StructurePieceAccessor)piece).invokeGetZWithOffset(x, z));
        boolean vecInside = box.func_175898_b((Vector3i)blockpos);
        boolean solidBelow = world.func_180495_p(blockpos.func_177977_b()).func_200132_m();
        boolean notSlabBelow = !(world.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof SlabBlock);
        boolean airAbove = world.func_175623_d(blockpos.func_177984_a());
        return vecInside && solidBelow && notSlabBelow && airAbove;
    }

    private static BlockState getFloorBlock(Random rand) {
        return rand.nextFloat() < rareBlockChance ? MineshaftImprovements.getRandomBlockFromList(rareFloorBlocks, rand) : MineshaftImprovements.getRandomBlockFromList(commonFloorBlocks, rand);
    }

    private static BlockState getCeilingBlock(Random rand) {
        return rand.nextFloat() < rareBlockChance ? MineshaftImprovements.getRandomBlockFromList(rareCeilingBlocks, rand) : MineshaftImprovements.getRandomBlockFromList(commonCeilingBlocks, rand);
    }

    private static BlockState getRandomBlockFromList(List<BlockState> blocks, Random rand) {
        return blocks.get(rand.nextInt(blocks.size()));
    }
}

