/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.ModHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.ExtractEnchantmentsClient;

@Module(mod="charm", client=ExtractEnchantmentsClient.class, description="Extract enchantments from any enchanted item into an empty book using the grindstone.")
public class ExtractEnchantments
extends CharmModule {
    @Config(name="Initial XP cost", description="Initial XP cost before adding XP equivalent to the enchantment level(s) of the item.")
    public static int initialCost = 2;

    @Override
    public boolean depends() {
        return !ModHelper.isLoaded("grindenchantments");
    }

    public static Slot getGrindstoneInputSlot(int index, IInventory inputs) {
        return new Slot(inputs, index, 49, 19 + index * 21){

            public boolean func_75214_a(ItemStack stack) {
                boolean valid;
                boolean bl = valid = stack.func_77984_f() || stack.func_77973_b() == Items.field_151134_bR || stack.func_77948_v();
                return ExtractEnchantments.isEnabled() ? valid || stack.func_77973_b() == Items.field_151122_aG : valid;
            }
        };
    }

    public static Slot getGrindstoneOutputSlot(final IWorldPosCallable context, final IInventory inputs, IInventory output) {
        return new Slot(output, 2, 129, 34){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity player) {
                if (!ExtractEnchantments.isEnabled()) {
                    return true;
                }
                List<ItemStack> stacks = ExtractEnchantments.getStacksFromInventory(this.field_75224_c);
                if (ExtractEnchantments.shouldExtract(stacks)) {
                    int cost = ExtractEnchantments.getEnchantedItemFromStacks(stacks).map(ExtractEnchantments::getCost).orElse(0);
                    return ExtractEnchantments.hasEnoughXp(player, cost);
                }
                return true;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                ItemStack out = ExtractEnchantments.tryGetEnchantedBook(inputs, player);
                context.func_221486_a((world, blockPos) -> {
                    if (out != null && out.func_77973_b() instanceof EnchantedBookItem) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            int cost = ExtractEnchantments.getCost(out);
                            player.func_82242_a(-cost);
                        }
                    } else {
                        int j;
                        for (int i = this.getExperience((World)world); i > 0; i -= j) {
                            j = ExperienceOrbEntity.func_70527_a((int)i);
                            world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, j));
                        }
                    }
                    world.func_217379_c(1042, blockPos, 0);
                });
                ItemStack slot0 = inputs.func_70301_a(0);
                ItemStack slot1 = inputs.func_70301_a(1);
                if (slot0.func_190916_E() > 1) {
                    slot0.func_190918_g(1);
                } else if (slot1.func_190916_E() > 1) {
                    slot1.func_190918_g(1);
                }
                if (slot0.func_190916_E() <= 1) {
                    inputs.func_70299_a(0, ItemStack.field_190927_a);
                }
                if (slot1.func_190916_E() <= 1) {
                    inputs.func_70299_a(1, ItemStack.field_190927_a);
                }
                return stack;
            }

            private int getExperience(World world) {
                int ix = 0;
                int i = ix + this.getExperience(inputs.func_70301_a(0));
                if ((i += this.getExperience(inputs.func_70301_a(1))) > 0) {
                    int j = (int)Math.ceil((double)i / 2.0);
                    return j + world.field_73012_v.nextInt(j);
                }
                return 0;
            }

            private int getExperience(ItemStack stack) {
                int i = 0;
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Map.Entry entry : map.entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    Integer integer = (Integer)entry.getValue();
                    if (enchantment.func_190936_d()) continue;
                    i += enchantment.func_77321_a(integer.intValue());
                }
                return i;
            }
        };
    }

    public static boolean tryUpdateResult(IInventory inputs, IInventory output, @Nullable PlayerEntity player) {
        if (!ExtractEnchantments.isEnabled()) {
            return false;
        }
        ItemStack out = ExtractEnchantments.tryGetEnchantedBook(inputs, player);
        if (out == null) {
            return false;
        }
        output.func_70299_a(0, out);
        return true;
    }

    @Nullable
    private static ItemStack tryGetEnchantedBook(IInventory inputs, @Nullable PlayerEntity player) {
        List<ItemStack> stacks = ExtractEnchantments.getStacksFromInventory(inputs);
        if (!ExtractEnchantments.shouldExtract(stacks)) {
            return null;
        }
        Optional<ItemStack> enchanted = ExtractEnchantments.getEnchantedItemFromStacks(stacks);
        if (!enchanted.isPresent()) {
            return null;
        }
        ItemStack in = enchanted.get();
        if (player != null && !ExtractEnchantments.hasEnoughXp(player, ExtractEnchantments.getCost(in))) {
            return null;
        }
        ItemStack out = new ItemStack((IItemProvider)Items.field_151134_bR);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)in);
        enchantments.forEach((e, level) -> EnchantedBookItem.func_92115_a((ItemStack)out, (EnchantmentData)new EnchantmentData(e, level.intValue())));
        return out;
    }

    private static boolean isEnabled() {
        return ModuleHandler.enabled(ExtractEnchantments.class);
    }

    public static List<ItemStack> getStacksFromInventory(IInventory inventory) {
        return Arrays.asList(inventory.func_70301_a(0), inventory.func_70301_a(1));
    }

    public static Optional<ItemStack> getEnchantedItemFromStacks(List<ItemStack> stacks) {
        return stacks.stream().filter(ItemStack::func_77948_v).findFirst();
    }

    public static boolean shouldExtract(List<ItemStack> stacks) {
        return ExtractEnchantments.getEnchantedItemFromStacks(stacks).isPresent() && stacks.stream().anyMatch(i -> i.func_77973_b() == Items.field_151122_aG);
    }

    public static boolean hasEnoughXp(PlayerEntity player, int cost) {
        return player.field_71075_bZ.field_75098_d || player.field_71068_ca >= cost;
    }

    public static int getCost(ItemStack stack) {
        int cost = initialCost;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : enchantments.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            if (ench == null) {
                return 0;
            }
            int level = (Integer)entry.getValue();
            if (level <= 0 || !ench.isAllowedOnBooks()) continue;
            cost += level;
        }
        if (stack.func_77978_p() != null && !stack.func_77978_p().isEmpty()) {
            cost += stack.func_77978_p().func_74762_e("RepairCost");
        }
        return cost;
    }
}

