/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.block.ICharmBlock;

public class PlayerPressurePlateBlock
extends AbstractPressurePlateBlock
implements ICharmBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private final CharmModule module;

    public PlayerPressurePlateBlock(CharmModule module) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200942_a().func_200948_a(2.0f, 1200.0f));
        this.module = module;
        this.register(module, "player_pressure_plate");
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78028_d;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.enabled()) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public boolean enabled() {
        return this.module.enabled;
    }

    protected void func_185507_b(@Nonnull IWorld worldIn, @Nonnull BlockPos pos) {
        worldIn.func_184133_a(null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    protected void func_185508_c(@Nonnull IWorld worldIn, @Nonnull BlockPos pos) {
        worldIn.func_184133_a(null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.4f);
    }

    protected int func_180669_e(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        AxisAlignedBB bounds = field_185511_c.func_186670_a(pos);
        List entities = worldIn.func_217357_a(PlayerEntity.class, bounds);
        return entities.stream().anyMatch(it -> !it.func_145773_az()) ? 15 : 0;
    }

    protected int func_176576_e(@Nonnull BlockState state) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    @Nonnull
    protected BlockState func_176575_a(@Nonnull BlockState state, int strength) {
        return (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }
}

