/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.block.CharmBlock;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.module.Crates;
import svenhjol.charm.tileentity.CrateTileEntity;

public class CrateBlock
extends CharmBlock {
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    private static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    private IVariantMaterial type;

    public CrateBlock(CharmModule module, IVariantMaterial type) {
        super(module, type.func_176610_l() + "_crate", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(1.5f));
        this.type = type;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrateTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78031_c;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        TileEntity tileEntity;
        if (itemStack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof CrateTileEntity) {
            ((CrateTileEntity)tileEntity).func_213903_a(itemStack.func_200301_q());
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tileEntity;
            if (!world.field_72995_K && player.func_184812_l_() && !crate.func_191420_l()) {
                ItemStack stack = new ItemStack((IItemProvider)CrateBlock.getBlockByMaterial(this.type));
                CompoundNBT tag = crate.func_189515_b(new CompoundNBT());
                if (!tag.isEmpty()) {
                    stack.func_77983_a(BLOCK_ENTITY_TAG, (INBT)tag);
                }
                if (crate.func_145818_k_()) {
                    stack.func_200302_a(crate.func_200201_e());
                }
                ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                entity.func_174869_p();
                world.func_217376_c((Entity)entity);
            } else {
                crate.func_184281_d(player);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileEntity instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tileEntity;
            builder = builder.func_216017_a(CONTENTS, (context, consumer) -> {
                for (int i = 0; i < crate.func_70302_i_(); ++i) {
                    consumer.accept(crate.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!world.field_72995_K && !player.func_175149_v() && (tileEntity = world.func_175625_s(pos)) instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tileEntity;
            crate.func_184281_d(player);
            player.func_213829_a((INamedContainerProvider)crate);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CrateTileEntity) {
                world.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, world, pos, newState, moved);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(world, pos, state);
        CrateTileEntity crate = (CrateTileEntity)world.func_175625_s(pos);
        if (crate == null) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT tag = crate.func_189515_b(new CompoundNBT());
        if (!tag.isEmpty()) {
            stack.func_77983_a(BLOCK_ENTITY_TAG, (INBT)tag);
        }
        return stack;
    }

    private static Block getBlockByMaterial(IVariantMaterial type) {
        return Crates.CRATE_BLOCKS.get(type);
    }
}

