/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.base.enums.VanillaVariantMaterial;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.DataBlockHelper;
import svenhjol.charm.base.helper.DecorationHelper;
import svenhjol.charm.base.helper.LootHelper;
import svenhjol.charm.block.BookcaseBlock;
import svenhjol.charm.module.Bookcases;
import svenhjol.charm.module.Crates;
import svenhjol.charm.module.EntitySpawners;
import svenhjol.charm.module.GoldLanterns;
import svenhjol.charm.module.VariantBarrels;
import svenhjol.charm.module.VariantBookshelves;
import svenhjol.charm.module.VariantChests;
import svenhjol.charm.tileentity.BookcaseTileEntity;
import svenhjol.charm.tileentity.EntitySpawnerTileEntity;

public class DataBlockProcessor
extends StructureProcessor {
    public DataBlockResolver resolver = new DataBlockResolver();
    public static Map<String, Consumer<DataBlockResolver>> callbacks = new HashMap<String, Consumer<DataBlockResolver>>();

    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, BlockPos blockPos, Template.BlockInfo unused, Template.BlockInfo blockInfo, PlacementSettings placement, @Nullable Template template) {
        StructureMode mode;
        if (blockInfo.field_186243_b.func_177230_c() == Blocks.field_185779_df && (mode = StructureMode.valueOf((String)blockInfo.field_186244_c.func_74779_i("mode"))) == StructureMode.DATA) {
            return this.resolver.replace(world, placement.func_186215_c(), blockInfo, new Random(pos.func_218275_a()));
        }
        return blockInfo;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return null;
    }

    public static class DataBlockResolver {
        private static final String ANVIL = "anvil";
        private static final String ARMOR = "armor";
        private static final String BLOCK = "block";
        private static final String BOOKSHELF = "bookshelf";
        private static final String CARPET = "carpet";
        private static final String CAULDRON = "cauldron";
        private static final String CHEST = "chest";
        private static final String DECORATION = "decoration";
        private static final String ENTITY = "entity";
        private static final String FLOWER = "flower";
        private static final String LANTERN = "lantern";
        private static final String LAVA = "lava";
        private static final String MOB = "mob";
        private static final String ORE = "ore";
        private static final String FLOWERPOT = "plantpot";
        private static final String RUBBLE = "rubble";
        private static final String RUNE = "rune";
        private static final String SAPLING = "sapling";
        private static final String SPAWNER = "spawner";
        private static final String STORAGE = "storage";
        public static float BLOCK_CHANCE = 0.8f;
        public static float BOOKCASE_CHANCE = 0.25f;
        public static float CHEST_CHANCE = 0.66f;
        public static float DECORATION_CHANCE = 0.85f;
        public static float FLOWER_CHANCE = 0.8f;
        public static float FLOWERPOT_CHANCE = 0.8f;
        public static float LANTERN_CHANCE = 0.9f;
        public static float LANTERN_GOLD_CHANCE = 0.25f;
        public static float LAVA_CHANCE = 0.7f;
        public static float MOB_CHANCE = 0.75f;
        public static float ORE_CHANCE = 0.75f;
        public static float RARE_ORE_CHANCE = 0.25f;
        public static float RARE_BOOKCASE_CHANCE = 0.05f;
        public static float RARE_CHEST_CHANCE = 0.1f;
        public static float RUBBLE_CHANCE = 0.9f;
        public static float RUNESTONE_CHANCE = 0.75f;
        public static float SAPLING_CHANCE = 0.8f;
        public static float SPAWNER_CHANCE = 0.8f;
        public static float STORAGE_CHANCE = 0.7f;
        public String data;
        public Rotation rotation;
        public BlockState state;
        public BlockPos pos;
        public IWorldReader world;
        public CompoundNBT tag;
        public Random fixedRandom;
        public Random random;
        public float chance;

        public Template.BlockInfo replace(IWorldReader world, Rotation rotation, Template.BlockInfo blockInfo, Random random) {
            String data = blockInfo.field_186244_c.func_74779_i("metadata");
            this.world = world;
            this.fixedRandom = random;
            this.rotation = rotation;
            this.pos = blockInfo.field_186242_a;
            this.state = null;
            this.tag = null;
            this.random = new Random(blockInfo.hashCode());
            if (data.contains("|")) {
                String[] split = data.split("\\|");
                data = split[this.random.nextInt(split.length)];
            }
            this.data = data.trim();
            this.chance = this.getChance(this.data, 0.0f);
            if (this.data.startsWith(ANVIL)) {
                this.anvil();
            }
            if (this.data.startsWith(ARMOR)) {
                this.armorStand();
            }
            if (this.data.startsWith(BLOCK)) {
                this.block();
            }
            if (this.data.startsWith(BOOKSHELF)) {
                this.bookshelf();
            }
            if (this.data.startsWith(CARPET)) {
                this.carpet();
            }
            if (this.data.startsWith(CAULDRON)) {
                this.cauldron();
            }
            if (this.data.startsWith(CHEST)) {
                this.chest();
            }
            if (this.data.startsWith(DECORATION)) {
                this.decoration();
            }
            if (this.data.startsWith(ENTITY)) {
                this.entity();
            }
            if (this.data.startsWith(FLOWER)) {
                this.flower();
            }
            if (this.data.startsWith(FLOWERPOT)) {
                this.flowerpot();
            }
            if (this.data.startsWith(LANTERN)) {
                this.lantern();
            }
            if (this.data.startsWith(LAVA)) {
                this.lava();
            }
            if (this.data.startsWith(MOB)) {
                this.mob();
            }
            if (this.data.startsWith(ORE)) {
                this.ore();
            }
            if (this.data.startsWith(SAPLING)) {
                this.sapling();
            }
            if (this.data.startsWith(SPAWNER)) {
                this.spawner();
            }
            if (this.data.startsWith(STORAGE)) {
                this.storage();
            }
            if (this.state == null) {
                callbacks.entrySet().stream().filter(entry -> this.data.startsWith((String)entry.getKey())).forEach(entry -> ((Consumer)entry.getValue()).accept(this));
                if (this.state == null) {
                    this.state = Blocks.field_150350_a.func_176223_P();
                }
            }
            return new Template.BlockInfo(this.pos, this.state, this.tag);
        }

        protected void anvil() {
            float f = this.random.nextFloat();
            if (f < 0.33f) {
                this.state = Blocks.field_150467_bQ.func_176223_P();
            } else if (f < 0.66f) {
                this.state = Blocks.field_196717_eY.func_176223_P();
            } else if (f < 1.0f) {
                this.state = Blocks.field_196718_eZ.func_176223_P();
            }
        }

        protected void armorStand() {
            EntitySpawnerTileEntity tileEntity = (EntitySpawnerTileEntity)EntitySpawners.TILE_ENTITY.func_200968_a();
            if (tileEntity == null) {
                return;
            }
            this.tag = new CompoundNBT();
            tileEntity.entity = new ResourceLocation("minecraft:armor_stand");
            tileEntity.meta = this.data;
            tileEntity.rotation = this.rotation;
            tileEntity.func_189515_b(this.tag);
            this.state = EntitySpawners.ENTITY_SPAWNER.func_176223_P();
        }

        protected void block() {
            if (!this.withChance(BLOCK_CHANCE)) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                return;
            }
            ResourceLocation typeId = new ResourceLocation(type);
            Optional optionalBlock = Registry.field_212618_g.func_241873_b(typeId);
            if (!optionalBlock.isPresent()) {
                return;
            }
            Block block = (Block)optionalBlock.get();
            this.state = block.func_176223_P();
        }

        protected void bookshelf() {
            IVariantMaterial material;
            IVariantMaterial variantMaterial = DecorationHelper.getRandomVariantMaterial(this.fixedRandom);
            String type = DataBlockHelper.getValue("material", this.data, "");
            if (!type.isEmpty() && (material = DecorationHelper.getVariantMaterial(type)) != null) {
                variantMaterial = material;
            }
            if (ModuleHandler.enabled(Bookcases.class) && this.withChance(BOOKCASE_CHANCE)) {
                this.state = (BlockState)Bookcases.BOOKCASE_BLOCKS.get(variantMaterial).func_176223_P().func_206870_a((Property)BookcaseBlock.SLOTS, (Comparable)Integer.valueOf(BookcaseTileEntity.SIZE));
                BookcaseTileEntity blockEntity = (BookcaseTileEntity)Bookcases.TILE_ENTITY.func_200968_a();
                if (blockEntity == null) {
                    return;
                }
                ResourceLocation lootTable = DecorationHelper.getRandomLootTable(this.random.nextFloat() < RARE_BOOKCASE_CHANCE ? DecorationHelper.RARE_BOOKCASE_LOOT_TABLES : DecorationHelper.BOOKCASE_LOOT_TABLES, this.random);
                blockEntity.func_189404_a(lootTable, this.random.nextLong());
                this.tag = new CompoundNBT();
                blockEntity.func_189515_b(this.tag);
            } else {
                this.state = ModuleHandler.enabled(VariantBookshelves.class) && variantMaterial != VanillaVariantMaterial.OAK ? VariantBookshelves.BOOKSHELF_BLOCKS.get(variantMaterial).func_176223_P() : Blocks.field_150342_X.func_176223_P();
            }
        }

        protected void carpet() {
            ArrayList<Block> types = new ArrayList<Block>(DecorationHelper.CARPETS);
            Collections.shuffle(types, this.fixedRandom);
            int type = DataBlockHelper.getValue("type", this.data, 0);
            if (type > types.size()) {
                type = 0;
            }
            this.state = ((Block)types.get(type)).func_176223_P();
        }

        protected void cauldron() {
            this.state = (BlockState)Blocks.field_150383_bp.func_176223_P().func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf((int)Math.max(3.0f, 4.0f * this.random.nextFloat())));
        }

        protected void chest() {
            if (!this.withChance(CHEST_CHANCE)) {
                return;
            }
            if (ModuleHandler.enabled(VariantChests.class)) {
                IVariantMaterial material;
                IVariantMaterial variantMaterial = DecorationHelper.getRandomVariantMaterial(this.random);
                String type = DataBlockHelper.getValue("material", this.data, "");
                if (!type.isEmpty() && (material = DecorationHelper.getVariantMaterial(type)) != null) {
                    variantMaterial = material;
                }
                this.state = this.random.nextFloat() < 0.05f ? VariantChests.TRAPPED_CHEST_BLOCKS.get(variantMaterial).func_176223_P() : VariantChests.NORMAL_CHEST_BLOCKS.get(variantMaterial).func_176223_P();
            } else {
                this.state = Blocks.field_150486_ae.func_176223_P();
            }
            this.state = DataBlockHelper.setFacing(this.state, ChestBlock.field_176459_a, DataBlockHelper.getValue("facing", this.data, "north"));
            ResourceLocation lootTable = DecorationHelper.getRandomLootTable(this.random.nextFloat() < RARE_CHEST_CHANCE ? DecorationHelper.RARE_CHEST_LOOT_TABLES : DecorationHelper.CHEST_LOOT_TABLES, this.random);
            ChestTileEntity tileEntity = (ChestTileEntity)TileEntityType.field_200972_c.func_200968_a();
            if (tileEntity == null) {
                return;
            }
            String loot = DataBlockHelper.getValue("loot", this.data, "");
            tileEntity.func_189404_a(LootHelper.getLootTable(loot, lootTable), this.random.nextLong());
            this.tag = new CompoundNBT();
            tileEntity.func_189515_b(this.tag);
        }

        protected void decoration() {
            if (!this.withChance(DECORATION_CHANCE)) {
                return;
            }
            Direction facing = DataBlockHelper.getFacing(DataBlockHelper.getValue("facing", this.data, "north"));
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.DECORATION_BLOCKS, this.random, facing);
        }

        protected void entity() {
            EntitySpawnerTileEntity tileEntity = (EntitySpawnerTileEntity)EntitySpawners.TILE_ENTITY.func_200968_a();
            if (tileEntity == null) {
                return;
            }
            this.tag = new CompoundNBT();
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                return;
            }
            ResourceLocation typeId = new ResourceLocation(type);
            if (!Registry.field_212629_r.func_241873_b(typeId).isPresent()) {
                return;
            }
            tileEntity.entity = typeId;
            tileEntity.meta = this.data;
            tileEntity.rotation = this.rotation;
            tileEntity.func_189515_b(this.tag);
            this.state = EntitySpawners.ENTITY_SPAWNER.func_176223_P();
        }

        protected void flower() {
            if (!this.withChance(FLOWER_CHANCE)) {
                return;
            }
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.FLOWERS, this.random);
        }

        protected void flowerpot() {
            if (!this.withChance(FLOWERPOT_CHANCE)) {
                return;
            }
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.FLOWER_POTS, this.random);
        }

        protected void lantern() {
            if (!this.withChance(LANTERN_CHANCE)) {
                return;
            }
            this.state = Blocks.field_222432_lU.func_176223_P();
            if (ModuleHandler.enabled(GoldLanterns.class) && this.random.nextFloat() < LANTERN_GOLD_CHANCE) {
                this.state = GoldLanterns.GOLD_LANTERN.func_176223_P();
            }
            if (this.data.contains("hanging")) {
                this.state = (BlockState)this.state.func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true));
            }
        }

        protected void lava() {
            this.state = Blocks.field_196814_hQ.func_176223_P();
            if (this.fixedRandom.nextFloat() < LAVA_CHANCE) {
                this.state = Blocks.field_150353_l.func_176223_P();
            }
        }

        protected void mob() {
            if (!this.withChance(MOB_CHANCE)) {
                return;
            }
            EntitySpawnerTileEntity tileEntity = (EntitySpawnerTileEntity)EntitySpawners.TILE_ENTITY.func_200968_a();
            if (tileEntity == null) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                return;
            }
            this.tag = new CompoundNBT();
            tileEntity.entity = new ResourceLocation(type);
            tileEntity.health = DataBlockHelper.getValue("health", this.data, 0.0);
            tileEntity.persist = DataBlockHelper.getValue("persist", this.data, true);
            tileEntity.armor = DataBlockHelper.getValue(ARMOR, this.data, "");
            tileEntity.effects = DataBlockHelper.getValue("effects", this.data, "");
            tileEntity.count = DataBlockHelper.getValue("count", this.data, 1);
            tileEntity.rotation = this.rotation;
            tileEntity.func_189515_b(this.tag);
            this.state = EntitySpawners.ENTITY_SPAWNER.func_176223_P();
        }

        protected void ore() {
            if (!this.withChance(ORE_CHANCE)) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (!type.isEmpty()) {
                ResourceLocation typeId = new ResourceLocation(type);
                if (!Registry.field_212629_r.func_241873_b(typeId).isPresent()) {
                    return;
                }
                Block ore = (Block)Registry.field_212618_g.func_82594_a(typeId);
                this.state = ore.func_176223_P();
                return;
            }
            this.state = this.fixedRandom.nextFloat() < RARE_ORE_CHANCE ? DecorationHelper.getRandomBlock(DecorationHelper.RARE_ORES, this.fixedRandom) : DecorationHelper.getRandomBlock(DecorationHelper.COMMON_ORES, this.fixedRandom);
        }

        protected void sapling() {
            if (!this.withChance(SAPLING_CHANCE)) {
                return;
            }
            this.state = DecorationHelper.getRandomBlock(DecorationHelper.SAPLINGS, this.random);
        }

        protected void spawner() {
            EntityType entity;
            if (!this.withChance(SPAWNER_CHANCE)) {
                return;
            }
            String type = DataBlockHelper.getValue("type", this.data, "");
            if (type.isEmpty()) {
                entity = DecorationHelper.SPAWNER_MOBS.size() > 0 ? DecorationHelper.SPAWNER_MOBS.get(this.random.nextInt(DecorationHelper.SPAWNER_MOBS.size())) : null;
            } else {
                ResourceLocation typeId = new ResourceLocation(type);
                if (!Registry.field_212629_r.func_241873_b(typeId).isPresent()) {
                    return;
                }
                entity = (EntityType)Registry.field_212629_r.func_82594_a(typeId);
            }
            if (entity == null) {
                return;
            }
            this.state = Blocks.field_150474_ac.func_176223_P();
            MobSpawnerTileEntity tileEntity = (MobSpawnerTileEntity)TileEntityType.field_200979_j.func_200968_a();
            if (tileEntity != null) {
                tileEntity.func_145881_a().func_200876_a(entity);
                this.tag = new CompoundNBT();
                tileEntity.func_189515_b(this.tag);
            }
        }

        protected void storage() {
            LockableLootTileEntity tileEntity;
            if (!this.withChance(STORAGE_CHANCE)) {
                return;
            }
            IVariantMaterial woodType = DecorationHelper.getRandomVariantMaterial(this.random);
            if (this.random.nextFloat() < 0.5f && ModuleHandler.enabled(Crates.class)) {
                this.state = Crates.CRATE_BLOCKS.get(woodType).func_176223_P();
                tileEntity = (LockableLootTileEntity)Crates.TILE_ENTITY.func_200968_a();
            } else {
                this.state = ModuleHandler.enabled(VariantBarrels.class) ? VariantBarrels.BARREL_BLOCKS.get(woodType).func_176223_P() : Blocks.field_222422_lK.func_176223_P();
                this.state = (BlockState)this.state.func_206870_a((Property)BarrelBlock.field_220092_a, (Comparable)Direction.UP);
                tileEntity = (LockableLootTileEntity)TileEntityType.field_222489_z.func_200968_a();
            }
            if (tileEntity == null) {
                return;
            }
            ResourceLocation lootTable = DecorationHelper.getRandomLootTable(DecorationHelper.COMMON_LOOT_TABLES, this.random);
            String loot = DataBlockHelper.getValue("loot", this.data, "");
            tileEntity.func_189404_a(LootHelper.getLootTable(loot, lootTable), this.random.nextLong());
            this.tag = new CompoundNBT();
            tileEntity.func_189515_b(this.tag);
        }

        public boolean withChance(float chance) {
            float f = this.random.nextFloat();
            return this.chance > 0.0f ? f < this.chance : f < chance;
        }

        public float getChance(String data, float fallback) {
            int i = DataBlockHelper.getValue("chance", data, 0);
            return i == 0 ? fallback : (float)i / 100.0f;
        }
    }
}

