/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.helper;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.base.helper.PosHelper;
import svenhjol.charm.mixin.accessor.GoalSelectorAccessor;
import svenhjol.charm.mixin.accessor.MobEntityAccessor;

public class MobHelper {
    public static Set<PrioritizedGoal> getGoals(MobEntity mob) {
        return ((GoalSelectorAccessor)MobHelper.getGoalSelector(mob)).getGoals();
    }

    public static GoalSelector getGoalSelector(MobEntity mob) {
        return ((MobEntityAccessor)mob).getGoalSelector();
    }

    public static <T extends Entity> T spawn(EntityType<T> type, ServerWorld world, BlockPos pos, SpawnReason reason) {
        return (T)type.func_220349_b(world, null, null, null, pos, reason, false, false);
    }

    public static void setEntityAttributes(EntityType<? extends LivingEntity> entityType, AttributeModifierMap attributes) {
        GlobalEntityTypeAttributes.put(entityType, (AttributeModifierMap)attributes);
    }

    public static boolean spawnMobNearPos(ServerWorld world, BlockPos pos, MobEntity mob, BiConsumer<MobEntity, BlockPos> onSpawn) {
        int surface;
        int range = 6;
        int tries = 8;
        Random random = world.field_73012_v;
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int y = surface = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.func_177958_n(), pos.func_177952_p()); y < surface + range; ++y) {
            block1: for (int i = range; i > 1; --i) {
                for (int c = 1; c < tries; ++c) {
                    boolean areaIsValid;
                    BlockPos checkPos = new BlockPos(pos.func_177958_n() + random.nextInt(i), y, pos.func_177952_p() + random.nextInt(i));
                    BlockPos floor = checkPos.func_177977_b();
                    BlockPos above = checkPos.func_177984_a();
                    boolean bl = areaIsValid = PosHelper.isLikeSolid((World)world, floor) && PosHelper.isLikeAir((World)world, checkPos) && PosHelper.isLikeAir((World)world, above);
                    if (areaIsValid) {
                        validPositions.add(checkPos);
                    }
                    if (validPositions.size() > 2) continue block1;
                }
            }
        }
        if (validPositions.isEmpty()) {
            return false;
        }
        BlockPos spawnPos = (BlockPos)validPositions.get(random.nextInt(validPositions.size()));
        mob.func_174828_a(spawnPos, 0.0f, 0.0f);
        mob.func_213386_a((IServerWorld)world, world.func_175649_E(spawnPos), SpawnReason.TRIGGERED, null, null);
        world.func_217376_c((Entity)mob);
        onSpawn.accept(mob, spawnPos);
        return true;
    }
}

