/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;

public class LootHelper {
    public static List<ResourceLocation> CUSTOM_LOOT_TABLES = new ArrayList<ResourceLocation>();
    public static Map<String, ResourceLocation> CACHED_LOOT_TABLES_NAMES = new HashMap<String, ResourceLocation>();

    public static List<ResourceLocation> getAllLootTables() {
        ArrayList<ResourceLocation> allLootTables = new ArrayList<ResourceLocation>();
        allLootTables.addAll(LootTables.func_215796_a());
        allLootTables.addAll(CUSTOM_LOOT_TABLES);
        return allLootTables;
    }

    public static List<ResourceLocation> getVanillaChestLootTables() {
        return LootHelper.getVanillaLootTables("chests/");
    }

    public static List<ResourceLocation> getVanillaVillageLootTables() {
        return LootHelper.getVanillaLootTables("/village/");
    }

    public static List<ResourceLocation> getVanillaLootTables(String pattern) {
        return LootTables.func_215796_a().stream().filter(t -> t.func_110623_a().contains(pattern)).collect(Collectors.toList());
    }

    public static ResourceLocation getLootTable(String loot, ResourceLocation fallback) {
        ResourceLocation lootTable = fallback;
        if (CACHED_LOOT_TABLES_NAMES.isEmpty()) {
            List<ResourceLocation> tables = LootHelper.getAllLootTables();
            for (ResourceLocation table : tables) {
                String[] s = table.func_110623_a().split("/");
                String last = s[s.length - 1];
                CACHED_LOOT_TABLES_NAMES.put(last, table);
            }
        }
        if (!loot.isEmpty()) {
            for (String s : CACHED_LOOT_TABLES_NAMES.keySet()) {
                if (!s.contains(loot)) continue;
                lootTable = CACHED_LOOT_TABLES_NAMES.get(s);
                break;
            }
        }
        return lootTable;
    }
}

