/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.BlockState;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import svenhjol.charm.base.helper.LootHelper;

public class DataBlockHelper {
    public static Direction getFacing(String direction) {
        if (direction.equals("east")) {
            return Direction.EAST;
        }
        if (direction.equals("south")) {
            return Direction.SOUTH;
        }
        if (direction.equals("west")) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public static BlockState setFacing(BlockState state, DirectionProperty prop, String direction) {
        if (direction.equals("north")) {
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Direction.NORTH);
        }
        if (direction.equals("east")) {
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Direction.EAST);
        }
        if (direction.equals("south")) {
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Direction.SOUTH);
        }
        if (direction.equals("west")) {
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Direction.WEST);
        }
        return state;
    }

    public static ResourceLocation getLootTable(String data, ResourceLocation fallback) {
        String loot = DataBlockHelper.getValue("loot", data, "");
        return LootHelper.getLootTable(loot, fallback);
    }

    public static boolean getValue(String key, String name, boolean fallback) {
        String val = DataBlockHelper.getValue(key, name, fallback ? "true" : "false");
        return val.isEmpty() ? fallback : Boolean.parseBoolean(val);
    }

    public static int getValue(String key, String name, int fallback) {
        int i = Integer.parseInt(DataBlockHelper.getValue(key, name, "0"));
        return i == 0 ? fallback : i;
    }

    public static double getValue(String key, String name, double fallback) {
        double d = Double.parseDouble(DataBlockHelper.getValue(key, name, "0"));
        return d == 0.0 ? fallback : d;
    }

    public static String getValue(String key, String data, String fallback) {
        Pattern p;
        Matcher m;
        String lookFor;
        String string = lookFor = key.endsWith("=") ? key : key + "=";
        if (data.contains(lookFor) && (m = (p = Pattern.compile(lookFor + "([a-zA-Z0-9_:\\-]+)")).matcher(data)).find()) {
            return m.group(1);
        }
        return fallback;
    }
}

