/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.handler;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.iface.Config;

public class ConfigHandler {
    private static final List<Runnable> refreshConfig = new ArrayList<Runnable>();

    public void createConfig(ModContainer forgeModContainer, Map<String, CharmModule> moduleMap) {
        ArrayList<CharmModule> modules = new ArrayList<CharmModule>(moduleMap.values());
        ForgeConfigSpec spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(b -> this.buildConfig((ForgeConfigSpec.Builder)b, (List<CharmModule>)new ArrayList<CharmModule>(modules))).getRight();
        ModConfig config = new ModConfig(ModConfig.Type.COMMON, spec, forgeModContainer);
        forgeModContainer.addConfig(config);
        this.earlyConfigHack(config, modules);
    }

    public static void refreshAllConfig() {
        refreshConfig.forEach(Runnable::run);
    }

    private Void buildConfig(ForgeConfigSpec.Builder builder, List<CharmModule> modules) {
        modules.forEach(module -> {
            if (!module.description.isEmpty()) {
                builder.comment(module.description);
            }
            if (module.alwaysEnabled) {
                module.enabled = true;
                return;
            }
            ForgeConfigSpec.BooleanValue val = builder.define(module.getName() + " enabled", module.enabledByDefault);
            refreshConfig.add(() -> ConfigHandler.lambda$null$1(module, (ForgeConfigSpec.ConfigValue)val));
        });
        modules.forEach(module -> {
            builder.push(module.getName());
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(module.getClass().getDeclaredFields()));
            fields.forEach(field -> {
                Config annotation = field.getDeclaredAnnotation(Config.class);
                if (annotation == null) {
                    return;
                }
                field.setAccessible(true);
                String name = annotation.name();
                String description = annotation.description();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                if (!description.isEmpty()) {
                    builder.comment(description);
                }
                try {
                    Object defaultVal = field.get(null);
                    ForgeConfigSpec.ConfigValue val = defaultVal instanceof List ? builder.defineList(name, (List)defaultVal, o -> true) : builder.define(name, defaultVal);
                    String finalName = name;
                    ForgeConfigSpec.ConfigValue finalVal = val;
                    refreshConfig.add(() -> {
                        try {
                            Charm.LOG.debug("[" + module.getName() + "] Setting config field " + finalName + " to " + finalVal.get());
                            field.set(null, val.get());
                        }
                        catch (IllegalAccessException e) {
                            Charm.LOG.error("Could not set config value for " + module.getName());
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (ReflectiveOperationException e) {
                    Charm.LOG.error("Failed to get config for " + module.getName());
                }
            });
            builder.pop();
        });
        return null;
    }

    private void earlyConfigHack(ModConfig config, List<CharmModule> modules) {
        Path path = FMLPaths.CONFIGDIR.get();
        if (path == null) {
            Charm.LOG.warn("Could not fetch config dir path");
            return;
        }
        String name = config.getFileName();
        if (name == null) {
            Charm.LOG.warn("Could not fetch mod config filename");
            return;
        }
        Path configPath = Paths.get(path.toString() + File.separator + name, new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            Charm.LOG.warn("Config file does not exist: " + path);
            return;
        }
        try {
            List<String> lines = Files.readAllLines(configPath);
            for (String line : lines) {
                if (!line.contains("enabled")) continue;
                modules.forEach(module -> {
                    if (line.contains(module.getName())) {
                        if (line.contains("false")) {
                            module.enabled = false;
                        } else if (line.contains("true")) {
                            module.enabled = true;
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Charm.LOG.warn("Could not read config file: " + e);
        }
    }

    private static /* synthetic */ void lambda$null$1(CharmModule module, ForgeConfigSpec.ConfigValue val) {
        module.enabled = module.enabled && (Boolean)val.get() != false;
    }
}

