/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.forgespi.language.IModInfo;
import tschipp.fakename.ClientProxy;
import tschipp.fakename.CommonProxy;
import tschipp.fakename.Config;
import tschipp.fakename.FakeNamePacket;
import tschipp.fakename.FakeNameSuggestionPackets;
import tschipp.fakename.IProxy;

@Mod(value="fakename")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FakeName {
    public static final String MODID = "fakename";
    public static IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static SimpleChannel network;
    public static IModInfo info;

    public FakeName() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        info = ModLoadingContext.get().getActiveContainer().getModInfo();
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.setup(event);
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "fakenamechannel"), () -> info.getVersion().toString(), s -> true, s -> true);
        network.registerMessage(0, FakeNamePacket.class, FakeNamePacket::toBytes, FakeNamePacket::new, FakeNamePacket::handle);
        network.registerMessage(1, FakeNameSuggestionPackets.GetFakeNamePacket.class, FakeNameSuggestionPackets.GetFakeNamePacket::toBytes, FakeNameSuggestionPackets.GetFakeNamePacket::new, FakeNameSuggestionPackets.GetFakeNamePacket::handle);
        network.registerMessage(2, FakeNameSuggestionPackets.UpdateFakeNamePacket.class, FakeNameSuggestionPackets.UpdateFakeNamePacket::toBytes, FakeNameSuggestionPackets.UpdateFakeNamePacket::new, FakeNameSuggestionPackets.UpdateFakeNamePacket::handle);
    }

    public static void sendPacket(PlayerEntity player, String fakename, int operation) {
        FakeName.performFakenameOperation(player, fakename, operation);
        network.send(PacketDistributor.ALL.noArg(), (Object)new FakeNamePacket(fakename, player.func_145782_y(), operation));
    }

    public static void performFakenameOperation(PlayerEntity player, String fakename, int operation) {
        CompoundNBT tag = player.getPersistentData();
        if (operation == 0) {
            tag.func_74778_a(MODID, fakename);
            player.refreshDisplayName();
        } else {
            tag.func_82580_o(MODID);
            player.refreshDisplayName();
        }
    }
}

