/*
 * Decompiled with CFR 0.152.
 */
package wolforce.simpleshops;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import wolforce.simpleshops.SimpleShops;
import wolforce.simpleshops.StackUtil;

public class SimpleShopTileEntity
extends TileEntity {
    public static final DeferredRegister<TileEntityType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"simpleshops");
    static Supplier<Collection<Block>> valid = () -> SimpleShops.blocks.values();
    public static final RegistryObject<TileEntityType<SimpleShopTileEntity>> TYPE = REGISTER.register("simple_shop_tile_entity", () -> new TileEntityType(SimpleShopTileEntity::new, SimpleShopTileEntity.setOf(valid.get()), null));
    private static final int COST_SLOT = 1;
    private static final int RESULT_SLOT = 0;
    private UUID owner = new UUID(0L, 0L);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private int invNr = 0;
    private int gainsNr = 0;
    private static final String NBT_INV = "inv";
    private static final String NBT_INV_NR = "inv_nr";
    private static final String NBT_GAINS_NR = "gains_nr";
    private static final String NBT_OWNER1 = "owner_part1";
    private static final String NBT_OWNER2 = "owner_part2";

    public SimpleShopTileEntity(TileEntityType<?> type) {
        super(type);
    }

    private static <T> Set<T> setOf(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    public SimpleShopTileEntity() {
        this((TileEntityType)TYPE.get());
    }

    public void setOwner(LivingEntity entity) {
        this.owner = entity.func_110124_au();
        this.func_70296_d();
    }

    public boolean isOwner(Block block, LivingEntity entity) {
        return block == SimpleShops.creative_simple_shop ? entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() : this.owner.equals(entity.func_110124_au());
    }

    private boolean isSoldOut() {
        return this.invNr < this.getOutputStack().func_190916_E();
    }

    public ItemStack getCost() {
        return ((ItemStack)this.inventory.get(1)).func_77946_l();
    }

    public void setCost(ItemStack stack) {
        this.inventory.set(1, (Object)stack.func_77946_l());
        this.sendUpdate();
    }

    public ItemStack getOutputStack() {
        return ((ItemStack)this.inventory.get(0)).func_77946_l();
    }

    public void setOutputStack(ItemStack stack) {
        this.inventory.set(0, (Object)stack.func_77946_l());
        this.sendUpdate();
    }

    public void clearCostAndOutputStacks() {
        this.inventory.clear();
        this.sendUpdate();
    }

    public ItemStack insertInv(PlayerEntity player, ItemStack stackToInsert) {
        ItemStack output = this.getOutputStack();
        if (output.func_190926_b()) {
            this.setOutputStack(stackToInsert);
            this.invNr += stackToInsert.func_190916_E();
            return ItemStack.field_190927_a;
        }
        int countToInsert = output.func_190916_E();
        if (!stackToInsert.func_77969_a(output) || stackToInsert.func_190916_E() < countToInsert) {
            return stackToInsert;
        }
        this.invNr += countToInsert;
        this.sendUpdate();
        return StackUtil.setCount(stackToInsert, stackToInsert.func_190916_E() - countToInsert);
    }

    public void tryBuy(PlayerEntity player, ItemStack input, boolean isCreative) {
        if (this.isSoldOut() && !isCreative) {
            return;
        }
        ItemStack cost = this.getCost();
        if (input.func_77969_a(cost) && input.func_190916_E() >= cost.func_190916_E()) {
            ItemStack result = this.getOutputStack();
            ItemStack change = StackUtil.setCount(input, input.func_190916_E() - cost.func_190916_E());
            if (!isCreative) {
                this.invNr -= result.func_190916_E();
            }
            this.gainsNr += cost.func_190916_E();
            this.spawn(player.field_70170_p, player.func_213303_ch(), result);
            player.func_184611_a(Hand.MAIN_HAND, change);
            this.sendUpdate();
        }
    }

    public void dropShop(PlayerEntity player, BlockPos pos) {
        this.dropAllInv(player);
        this.dropAllGains(player);
        if (!this.getCost().func_190926_b()) {
            this.clearCostAndOutputStacks();
        } else {
            player.field_70170_p.func_217377_a(pos, true);
            this.spawn(this.field_145850_b, player.func_213303_ch(), new ItemStack((IItemProvider)SimpleShops.simple_shop));
        }
    }

    public void popGains(PlayerEntity player) {
        if (this.gainsNr <= 0) {
            return;
        }
        this.dropAllGains(player);
        this.sendUpdate();
    }

    private void dropAllInv(PlayerEntity player) {
        ItemStack item = this.getOutputStack();
        while (this.invNr > 64) {
            this.invNr -= 64;
            this.spawn(player.field_70170_p, player.func_213303_ch(), item, 64);
        }
        this.spawn(player.field_70170_p, player.func_213303_ch(), item, this.invNr);
        this.invNr = 0;
    }

    private void dropAllGains(PlayerEntity player) {
        ItemStack item = this.getCost();
        while (this.gainsNr > 64) {
            this.gainsNr -= 64;
            this.spawn(player.field_70170_p, player.func_213303_ch(), item, 64);
        }
        this.spawn(player.field_70170_p, player.func_213303_ch(), item, this.gainsNr);
        this.gainsNr = 0;
    }

    private void spawn(World world, Vector3d pos, ItemStack stack, int amount) {
        this.spawn(world, pos, StackUtil.setCount(stack, amount));
    }

    private void spawn(World world, Vector3d pos, ItemStack stack) {
        world.func_217376_c((Entity)new ItemEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack.func_77946_l()));
    }

    public void write(CompoundNBT nbt) {
        CompoundNBT invNbt = ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), this.inventory);
        nbt.func_218657_a(NBT_INV, (INBT)invNbt);
        nbt.func_74768_a(NBT_INV_NR, this.invNr);
        nbt.func_74768_a(NBT_GAINS_NR, this.gainsNr);
        nbt.func_74772_a(NBT_OWNER1, this.owner.getMostSignificantBits());
        nbt.func_74772_a(NBT_OWNER2, this.owner.getLeastSignificantBits());
    }

    public void read(BlockState state, CompoundNBT nbt) {
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l(NBT_INV), this.inventory);
        this.invNr = nbt.func_74762_e(NBT_INV_NR);
        this.gainsNr = nbt.func_74762_e(NBT_GAINS_NR);
        this.owner = new UUID(nbt.func_74763_f(NBT_OWNER1), nbt.func_74763_f(NBT_OWNER2));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.write(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.read(state, nbt);
        super.func_230337_a_(state, nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.write(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.read(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    private void sendUpdate() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, SimpleShops.simple_shop.func_176223_P(), SimpleShops.simple_shop.func_176223_P(), 3);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.write(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.read(state, tag);
        super.handleUpdateTag(state, tag);
    }
}

