/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.item;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.goblintraders.mixin.SpawnEggItemMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;

public class SupplierSpawnEggItem
extends SpawnEggItem {
    private static final List<SupplierSpawnEggItem> EGGS = new ArrayList<SupplierSpawnEggItem>();
    private final Supplier<EntityType<?>> typeSupplier;

    public SupplierSpawnEggItem(Supplier<EntityType<?>> typeSupplier, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(null, primaryColorIn, secondaryColorIn, builder);
        this.typeSupplier = typeSupplier;
        EGGS.add(this);
    }

    public EntityType<?> func_208076_b(CompoundNBT tag) {
        return this.typeSupplier.get();
    }

    public static void updateEggMap() {
        SpawnEggItemMixin.getEggMap().remove(null);
        IDispenseItemBehavior eggDispenseBehaviour = (source, stack) -> {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            type.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack.func_190918_g(1);
            return stack;
        };
        EGGS.forEach(spawnEggItem -> {
            SpawnEggItemMixin.getEggMap().put(spawnEggItem.typeSupplier.get(), (SpawnEggItem)spawnEggItem);
            DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)eggDispenseBehaviour);
        });
    }

    public static List<SupplierSpawnEggItem> getSupplierEggs() {
        return ImmutableList.copyOf(EGGS);
    }
}

